/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.symbols;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.php.tree.symbols.Scope;
import org.sonar.php.tree.symbols.SymbolVisitor;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.symbols.SymbolTable;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.IdentifierTree;

public class SymbolTableImpl
implements SymbolTable {
    private List<Symbol> symbols = new ArrayList<Symbol>();
    private Set<Scope> scopes = Sets.newHashSet();
    private Map<Tree, Symbol> symbolsByTree = new HashMap<Tree, Symbol>();

    private SymbolTableImpl() {
    }

    public static SymbolTableImpl create(CompilationUnitTree compilationUnit) {
        SymbolTableImpl symbolModel = new SymbolTableImpl();
        new SymbolVisitor(symbolModel).visitCompilationUnit(compilationUnit);
        return symbolModel;
    }

    public void addScope(Scope scope) {
        this.scopes.add(scope);
    }

    public ImmutableSet<Scope> getScopes() {
        return ImmutableSet.copyOf(this.scopes);
    }

    @Override
    @Nullable
    public Scope getScopeFor(Tree tree) {
        for (Scope scope : this.scopes) {
            if (!scope.tree().equals(tree)) continue;
            return scope;
        }
        return null;
    }

    public Symbol declareSymbol(IdentifierTree name, Symbol.Kind kind, Scope scope) {
        Symbol symbol = new Symbol(name, kind, scope);
        this.symbols.add(symbol);
        scope.addSymbol(symbol);
        return symbol;
    }

    public ImmutableList<Symbol> getSymbols() {
        return ImmutableList.copyOf(this.symbols);
    }

    @Override
    public List<Symbol> getSymbols(Symbol.Kind kind) {
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        for (Symbol symbol : this.getSymbols()) {
            if (!kind.equals((Object)symbol.kind())) continue;
            result.add(symbol);
        }
        return result;
    }

    public List<Symbol> getSymbols(String name) {
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        for (Symbol symbol : this.getSymbols()) {
            if (!name.equalsIgnoreCase(symbol.name())) continue;
            result.add(symbol);
        }
        return result;
    }

    void associateSymbol(Tree identifier, Symbol symbol) {
        this.symbolsByTree.put(identifier, symbol);
    }

    @Override
    @CheckForNull
    public Symbol getSymbol(Tree tree) {
        return this.symbolsByTree.get(tree);
    }
}

