/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.symbols;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.tree.Tree;

public class Scope {
    private final Scope outer;
    private final Tree tree;
    protected List<Symbol> symbols = new ArrayList<Symbol>();
    Scope superClassScope;

    public Scope(Scope outer, Tree tree) {
        this.outer = outer;
        this.tree = tree;
    }

    public Tree tree() {
        return this.tree;
    }

    public Scope outer() {
        return this.outer;
    }

    public List<Symbol> getSymbols(Symbol.Kind kind) {
        LinkedList<Symbol> result = new LinkedList<Symbol>();
        for (Symbol symbol : this.symbols) {
            if (!symbol.is(kind)) continue;
            result.add(symbol);
        }
        return result;
    }

    public boolean isGlobal() {
        return this.tree.is(Tree.Kind.COMPILATION_UNIT);
    }

    public void addSymbol(Symbol symbol) {
        this.symbols.add(symbol);
    }

    @Nullable
    public Symbol getSymbol(String name, Symbol.Kind ... kinds) {
        List<Symbol.Kind> kindList = Arrays.asList(kinds);
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        for (Symbol s : this.symbols) {
            if (!s.called(name) || !kindList.isEmpty() && !kindList.contains((Object)s.kind())) continue;
            result.add(s);
        }
        if (result.isEmpty() && this.superClassScope != null) {
            return this.superClassScope.getSymbol(name, kinds);
        }
        return result.size() == 1 ? (Symbol)result.get(0) : null;
    }
}

