/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.statement;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.SeparatedListImpl;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.VariableDeclarationTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.StaticStatementTree;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class StaticStatementTreeImpl
extends PHPTree
implements StaticStatementTree {
    private static final Tree.Kind KIND = Tree.Kind.STATIC_STATEMENT;
    private final InternalSyntaxToken staticToken;
    private final SeparatedListImpl<VariableDeclarationTree> variables;
    private final InternalSyntaxToken eosToken;

    public StaticStatementTreeImpl(InternalSyntaxToken staticToken, SeparatedListImpl<VariableDeclarationTree> variables, InternalSyntaxToken eosToken) {
        this.staticToken = staticToken;
        this.variables = variables;
        this.eosToken = eosToken;
    }

    @Override
    public Tree.Kind getKind() {
        return KIND;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat(Iterators.singletonIterator(this.staticToken), this.variables.elementsAndSeparators(), Iterators.singletonIterator(this.eosToken));
    }

    @Override
    public SyntaxToken staticToken() {
        return this.staticToken;
    }

    public SeparatedListImpl<VariableDeclarationTree> variables() {
        return this.variables;
    }

    @Override
    public SyntaxToken eosToken() {
        return this.eosToken;
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitStaticStatement(this);
    }
}

