/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.statement;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.statement.NamespaceStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class NamespaceStatementTreeImpl
extends PHPTree
implements NamespaceStatementTree {
    private static final Tree.Kind KIND = Tree.Kind.NAMESPACE_STATEMENT;
    private final InternalSyntaxToken namespaceToken;
    private final NamespaceNameTree namespaceName;
    private final InternalSyntaxToken openCurlyBrace;
    private final List<StatementTree> statements;
    private final InternalSyntaxToken closeCurlyBrace;
    private final InternalSyntaxToken eosToken;

    public NamespaceStatementTreeImpl(InternalSyntaxToken namespaceToken, NamespaceNameTree namespaceName, InternalSyntaxToken eosToken) {
        this.namespaceToken = namespaceToken;
        this.namespaceName = namespaceName;
        this.eosToken = eosToken;
        this.openCurlyBrace = null;
        this.statements = ImmutableList.of();
        this.closeCurlyBrace = null;
    }

    public NamespaceStatementTreeImpl(InternalSyntaxToken namespaceToken, @Nullable NamespaceNameTree namespaceName, InternalSyntaxToken openCurlyBrace, List<StatementTree> statements, InternalSyntaxToken closeCurlyBrace) {
        this.namespaceToken = namespaceToken;
        this.namespaceName = namespaceName;
        this.openCurlyBrace = openCurlyBrace;
        this.statements = statements;
        this.closeCurlyBrace = closeCurlyBrace;
        this.eosToken = null;
    }

    @Override
    public InternalSyntaxToken namespaceToken() {
        return this.namespaceToken;
    }

    @Override
    @Nullable
    public NamespaceNameTree namespaceName() {
        return this.namespaceName;
    }

    @Override
    @Nullable
    public InternalSyntaxToken openCurlyBrace() {
        return this.openCurlyBrace;
    }

    @Override
    public List<StatementTree> statements() {
        return this.statements;
    }

    @Override
    @Nullable
    public InternalSyntaxToken closeCurlyBrace() {
        return this.closeCurlyBrace;
    }

    @Override
    @Nullable
    public InternalSyntaxToken eosToken() {
        return this.eosToken;
    }

    @Override
    public Tree.Kind getKind() {
        return KIND;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat(Iterators.forArray(this.namespaceToken, this.namespaceName, this.openCurlyBrace), this.statements.iterator(), Iterators.forArray(this.closeCurlyBrace, this.eosToken));
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitNamespaceStatement(this);
    }
}

