/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.statement;

import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class ElseClauseTreeImpl
extends PHPTree
implements ElseClauseTree {
    private final Tree.Kind kind;
    private final InternalSyntaxToken elseToken;
    private final InternalSyntaxToken colonToken;
    private final List<StatementTree> statements;

    public ElseClauseTreeImpl(InternalSyntaxToken elseToken, StatementTree statement) {
        this.kind = Tree.Kind.ELSE_CLAUSE;
        this.elseToken = elseToken;
        this.statements = Collections.singletonList(statement);
        this.colonToken = null;
    }

    public ElseClauseTreeImpl(InternalSyntaxToken elseToken, InternalSyntaxToken colonToken, List<StatementTree> statements) {
        this.kind = Tree.Kind.ALTERNATIVE_ELSE_CLAUSE;
        this.elseToken = elseToken;
        this.statements = statements;
        this.colonToken = colonToken;
    }

    @Override
    public SyntaxToken elseToken() {
        return this.elseToken;
    }

    @Override
    @Nullable
    public SyntaxToken colonToken() {
        return this.colonToken;
    }

    @Override
    public List<StatementTree> statements() {
        return this.statements;
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat(Iterators.forArray(this.elseToken, this.colonToken), this.statements.iterator());
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitElseClause(this);
    }
}

