/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.statement;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.BlockTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class BlockTreeImpl
extends PHPTree
implements BlockTree {
    private static final Tree.Kind KIND = Tree.Kind.BLOCK;
    private final InternalSyntaxToken openCurlyBraceToken;
    private final List<StatementTree> statements;
    private final InternalSyntaxToken closeCurlyBraceToken;

    public BlockTreeImpl(InternalSyntaxToken lbrace, List<StatementTree> statements, InternalSyntaxToken rbrace) {
        this.openCurlyBraceToken = lbrace;
        this.statements = statements;
        this.closeCurlyBraceToken = rbrace;
    }

    @Override
    public SyntaxToken openCurlyBraceToken() {
        return this.openCurlyBraceToken;
    }

    @Override
    public List<StatementTree> statements() {
        return this.statements;
    }

    @Override
    public SyntaxToken closeCurlyBraceToken() {
        return this.closeCurlyBraceToken;
    }

    @Override
    public Tree.Kind getKind() {
        return KIND;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat(Iterators.singletonIterator(this.openCurlyBraceToken), this.statements.iterator(), Iterators.singletonIterator(this.closeCurlyBraceToken));
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitBlock(this);
    }
}

