/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.expression;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.VariableVariableTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class VariableVariableTreeImpl
extends PHPTree
implements VariableVariableTree {
    private static final Tree.Kind KIND = Tree.Kind.VARIABLE_VARIABLE;
    private final ImmutableList<SyntaxToken> dollars;
    private final ExpressionTree variable;

    public VariableVariableTreeImpl(List<InternalSyntaxToken> dollars, ExpressionTree variable) {
        this.dollars = ImmutableList.copyOf(dollars);
        this.variable = variable;
    }

    @Override
    public List<SyntaxToken> dollarTokens() {
        return this.dollars;
    }

    @Override
    public ExpressionTree variableExpression() {
        return this.variable;
    }

    @Override
    public Tree.Kind getKind() {
        return KIND;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat(this.dollars.iterator(), Iterators.singletonIterator(this.variable));
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitVariableVariable(this);
    }
}

