/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.expression;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class ParenthesizedExpressionTreeImpl
extends PHPTree
implements ParenthesisedExpressionTree {
    private static final Tree.Kind KIND = Tree.Kind.PARENTHESISED_EXPRESSION;
    private final InternalSyntaxToken openParenthesis;
    private final ExpressionTree expression;
    private final InternalSyntaxToken closeParenthesis;

    public ParenthesizedExpressionTreeImpl(InternalSyntaxToken openParenthesis, ExpressionTree expression, InternalSyntaxToken closeParenthesis) {
        this.openParenthesis = openParenthesis;
        this.expression = expression;
        this.closeParenthesis = closeParenthesis;
    }

    @Override
    public Tree.Kind getKind() {
        return KIND;
    }

    @Override
    public SyntaxToken openParenthesis() {
        return this.openParenthesis;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken closeParenthesis() {
        return this.closeParenthesis;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray(this.openParenthesis, this.expression, this.closeParenthesis);
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitParenthesisedExpression(this);
    }
}

