/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.expression;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.sonar.php.api.PHPPunctuator;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class MemberAccessTreeImpl
extends PHPTree
implements MemberAccessTree {
    private final Tree.Kind kind;
    private ExpressionTree object;
    private final InternalSyntaxToken accessToken;
    private final Tree member;

    public MemberAccessTreeImpl(Tree.Kind kind, InternalSyntaxToken accessToken, Tree member) {
        this.kind = kind;
        this.accessToken = accessToken;
        this.member = member;
    }

    public MemberAccessTree complete(ExpressionTree object) {
        this.object = object;
        return this;
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public ExpressionTree object() {
        return this.object;
    }

    @Override
    public SyntaxToken accessToken() {
        return this.accessToken;
    }

    @Override
    public Tree member() {
        return this.member;
    }

    @Override
    public boolean isStatic() {
        return PHPPunctuator.DOUBLECOLON.getValue().equals(this.accessToken.text());
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray(this.object, this.accessToken, this.member);
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitMemberAccess(this);
    }
}

