/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.expression;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.SeparatedListImpl;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class FunctionCallTreeImpl
extends PHPTree
implements FunctionCallTree {
    private static final Tree.Kind KIND = Tree.Kind.FUNCTION_CALL;
    private ExpressionTree callee;
    private final InternalSyntaxToken openParenthesisToken;
    private final SeparatedListImpl<ExpressionTree> arguments;
    private final InternalSyntaxToken closeParenthesisToken;

    public FunctionCallTreeImpl(ExpressionTree callee, InternalSyntaxToken openParenthesisToken, SeparatedListImpl<ExpressionTree> arguments, InternalSyntaxToken closeParenthesisToken) {
        this.callee = callee;
        this.openParenthesisToken = openParenthesisToken;
        this.arguments = arguments;
        this.closeParenthesisToken = closeParenthesisToken;
    }

    public FunctionCallTreeImpl(ExpressionTree callee, SeparatedListImpl<ExpressionTree> arguments) {
        this.callee = callee;
        this.openParenthesisToken = null;
        this.arguments = arguments;
        this.closeParenthesisToken = null;
    }

    public FunctionCallTreeImpl(InternalSyntaxToken openParenthesisToken, SeparatedListImpl<ExpressionTree> arguments, InternalSyntaxToken closeParenthesisToken) {
        this.openParenthesisToken = openParenthesisToken;
        this.arguments = arguments;
        this.closeParenthesisToken = closeParenthesisToken;
    }

    public FunctionCallTreeImpl complete(ExpressionTree callee) {
        this.callee = callee;
        return this;
    }

    @Override
    public ExpressionTree callee() {
        return this.callee;
    }

    @Override
    @Nullable
    public SyntaxToken openParenthesisToken() {
        return this.openParenthesisToken;
    }

    public SeparatedListImpl<ExpressionTree> arguments() {
        return this.arguments;
    }

    @Override
    @Nullable
    public SyntaxToken closeParenthesisToken() {
        return this.closeParenthesisToken;
    }

    @Override
    public Tree.Kind getKind() {
        return KIND;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat(Iterators.singletonIterator(this.callee), Iterators.singletonIterator(this.openParenthesisToken), this.arguments.elementsAndSeparators(), Iterators.singletonIterator(this.closeParenthesisToken));
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitFunctionCall(this);
    }
}

