/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.expression;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpandableStringCharactersTree;
import org.sonar.plugins.php.api.tree.expression.ExpandableStringLiteralTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class ExpandableStringLiteralTreeImpl
extends PHPTree
implements ExpandableStringLiteralTree {
    private static final Tree.Kind KIND = Tree.Kind.EXPANDABLE_STRING_LITERAL;
    private final SyntaxToken openDoubleQuote;
    private final List<ExpressionTree> elements;
    private final SyntaxToken closeDoubleQuote;

    public ExpandableStringLiteralTreeImpl(InternalSyntaxToken openDoubleQuote, List<ExpressionTree> elements, InternalSyntaxToken closeDoubleQuote) {
        this.openDoubleQuote = openDoubleQuote;
        this.elements = elements;
        this.closeDoubleQuote = closeDoubleQuote;
    }

    @Override
    public Tree.Kind getKind() {
        return KIND;
    }

    @Override
    public SyntaxToken openDoubleQuoteToken() {
        return this.openDoubleQuote;
    }

    @Override
    public List<ExpandableStringCharactersTree> strings() {
        return ImmutableList.copyOf(Iterables.filter(this.elements, ExpandableStringCharactersTree.class));
    }

    @Override
    public List<ExpressionTree> expressions() {
        return ImmutableList.copyOf(Iterables.filter(this.elements, new Predicate<ExpressionTree>(){

            @Override
            public boolean apply(@Nullable ExpressionTree input) {
                return input != null ? !input.is(Tree.Kind.EXPANDABLE_STRING_CHARACTERS) : false;
            }
        }));
    }

    @Override
    public SyntaxToken closeDoubleQuoteToken() {
        return this.closeDoubleQuote;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat(Iterators.singletonIterator(this.openDoubleQuote), this.elements.iterator(), Iterators.singletonIterator(this.closeDoubleQuote));
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitExpandableStringLiteral(this);
    }
}

