/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.expression;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.SeparatedListImpl;
import org.sonar.plugins.php.api.tree.SeparatedList;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassMemberTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class AnonymousClassTreeImpl
extends PHPTree
implements AnonymousClassTree {
    private static final Tree.Kind KIND = Tree.Kind.ANONYMOUS_CLASS;
    private final SyntaxToken classToken;
    private final SyntaxToken openParenthesisToken;
    private final SeparatedList<ExpressionTree> arguments;
    private final SyntaxToken closeParenthesisToken;
    private final SyntaxToken extendsToken;
    private final NamespaceNameTree superClass;
    private final SyntaxToken implementsToken;
    private final SeparatedListImpl<NamespaceNameTree> superInterfaces;
    private final SyntaxToken openCurlyBraceToken;
    private final List<ClassMemberTree> members;
    private final SyntaxToken closeCurlyBraceToken;

    public AnonymousClassTreeImpl(SyntaxToken classToken, @Nullable SyntaxToken openParenthesisToken, SeparatedList<ExpressionTree> arguments, @Nullable SyntaxToken closeParenthesisToken, @Nullable SyntaxToken extendsToken, @Nullable NamespaceNameTree superClass, @Nullable SyntaxToken implementsToken, @Nullable SeparatedListImpl<NamespaceNameTree> superInterfaces, SyntaxToken openCurlyBraceToken, List<ClassMemberTree> members, SyntaxToken closeCurlyBraceToken) {
        this.classToken = classToken;
        this.openParenthesisToken = openParenthesisToken;
        this.arguments = arguments;
        this.closeParenthesisToken = closeParenthesisToken;
        this.extendsToken = extendsToken;
        this.superClass = superClass;
        this.implementsToken = implementsToken;
        this.superInterfaces = superInterfaces;
        this.openCurlyBraceToken = openCurlyBraceToken;
        this.members = members;
        this.closeCurlyBraceToken = closeCurlyBraceToken;
    }

    @Override
    public SyntaxToken classToken() {
        return this.classToken;
    }

    @Override
    @Nullable
    public SyntaxToken openParenthesisToken() {
        return this.openCurlyBraceToken;
    }

    @Override
    public SeparatedList<ExpressionTree> arguments() {
        return this.arguments;
    }

    @Override
    @Nullable
    public SyntaxToken closeParenthesisToken() {
        return this.closeCurlyBraceToken;
    }

    @Override
    @Nullable
    public SyntaxToken extendsToken() {
        return this.extendsToken;
    }

    @Override
    @Nullable
    public NamespaceNameTree superClass() {
        return this.superClass;
    }

    @Override
    @Nullable
    public SyntaxToken implementsToken() {
        return this.implementsToken;
    }

    @Override
    public SeparatedList<NamespaceNameTree> superInterfaces() {
        return this.superInterfaces;
    }

    @Override
    public SyntaxToken openCurlyBraceToken() {
        return this.openCurlyBraceToken;
    }

    @Override
    public List<ClassMemberTree> members() {
        return this.members;
    }

    @Override
    public SyntaxToken closeCurlyBraceToken() {
        return this.closeCurlyBraceToken;
    }

    @Override
    @Nullable
    public MethodDeclarationTree fetchConstructor() {
        MethodDeclarationTree constructor = null;
        for (ClassMemberTree member : this.members) {
            MethodDeclarationTree method;
            String methodName;
            if (!member.is(Tree.Kind.METHOD_DECLARATION) || !"__construct".equalsIgnoreCase(methodName = (method = (MethodDeclarationTree)member).name().text())) continue;
            constructor = method;
        }
        return constructor;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat(Iterators.forArray(this.classToken, this.openParenthesisToken), this.arguments.elementsAndSeparators(), Iterators.forArray(this.closeParenthesisToken, this.extendsToken, this.superClass, this.implementsToken), this.superInterfaces.elementsAndSeparators(), Iterators.singletonIterator(this.openCurlyBraceToken), this.members.iterator(), Iterators.singletonIterator(this.closeCurlyBraceToken));
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitAnonymousClass(this);
    }

    @Override
    public Tree.Kind getKind() {
        return KIND;
    }
}

