/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.declaration;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.SeparatedListImpl;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassPropertyDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.VariableDeclarationTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class ClassPropertyDeclarationTreeImpl
extends PHPTree
implements ClassPropertyDeclarationTree {
    private final Tree.Kind kind;
    private final List<SyntaxToken> modifierTokens;
    private final SeparatedListImpl<VariableDeclarationTree> declarations;
    private final InternalSyntaxToken eosToken;

    private ClassPropertyDeclarationTreeImpl(Tree.Kind kind, List<SyntaxToken> modifierTokens, SeparatedListImpl<VariableDeclarationTree> declarations, InternalSyntaxToken eosToken) {
        this.kind = kind;
        this.modifierTokens = modifierTokens;
        this.declarations = declarations;
        this.eosToken = eosToken;
    }

    public static ClassPropertyDeclarationTree variable(List<SyntaxToken> modifierTokens, SeparatedListImpl<VariableDeclarationTree> declarations, InternalSyntaxToken eosToken) {
        return new ClassPropertyDeclarationTreeImpl(Tree.Kind.CLASS_PROPERTY_DECLARATION, modifierTokens, declarations, eosToken);
    }

    public static ClassPropertyDeclarationTree constant(@Nullable SyntaxToken visibility, SyntaxToken constToken, SeparatedListImpl<VariableDeclarationTree> declarations, InternalSyntaxToken eosToken) {
        ImmutableList<SyntaxToken> modifierTokens = visibility != null ? ImmutableList.of(visibility, constToken) : ImmutableList.of(constToken);
        return new ClassPropertyDeclarationTreeImpl(Tree.Kind.CLASS_CONSTANT_PROPERTY_DECLARATION, modifierTokens, declarations, eosToken);
    }

    @Override
    public List<SyntaxToken> modifierTokens() {
        return this.modifierTokens;
    }

    public SeparatedListImpl<VariableDeclarationTree> declarations() {
        return this.declarations;
    }

    @Override
    public SyntaxToken eosToken() {
        return this.eosToken;
    }

    @Override
    public boolean hasModifiers(String ... modifiers) {
        int counter = 0;
        for (String modifier : modifiers) {
            if (!this.hasModifier(modifier)) continue;
            ++counter;
        }
        return counter == modifiers.length;
    }

    public boolean hasModifier(String modifier) {
        for (SyntaxToken token : this.modifierTokens()) {
            if (!token.text().equals(modifier)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat(this.modifierTokens.iterator(), this.declarations.elementsAndSeparators(), Iterators.singletonIterator(this.eosToken));
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitClassPropertyDeclaration(this);
    }
}

