/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.declaration;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.SeparatedListImpl;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassMemberTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class ClassDeclarationTreeImpl
extends PHPTree
implements ClassDeclarationTree {
    private final Tree.Kind kind;
    private final SyntaxToken modifierToken;
    private final SyntaxToken classEntryTypeToken;
    private final NameIdentifierTree name;
    private final SyntaxToken extendsToken;
    private final NamespaceNameTree superClass;
    private final SyntaxToken implementsToken;
    private final SeparatedListImpl<NamespaceNameTree> superInterfaces;
    private final SyntaxToken openCurlyBraceToken;
    private final List<ClassMemberTree> members;
    private final SyntaxToken closeCurlyBraceToken;

    private ClassDeclarationTreeImpl(Tree.Kind kind, @Nullable SyntaxToken modifierToken, SyntaxToken classEntryTypeToken, NameIdentifierTree name, @Nullable SyntaxToken extendsToken, @Nullable NamespaceNameTree superClass, @Nullable SyntaxToken implementsToken, SeparatedListImpl<NamespaceNameTree> superInterfaces, SyntaxToken openCurlyBraceToken, List<ClassMemberTree> members, SyntaxToken closeCurlyBraceToken) {
        this.kind = kind;
        this.modifierToken = modifierToken;
        this.classEntryTypeToken = classEntryTypeToken;
        this.name = name;
        this.extendsToken = extendsToken;
        this.superClass = superClass;
        this.implementsToken = implementsToken;
        this.superInterfaces = superInterfaces;
        this.openCurlyBraceToken = openCurlyBraceToken;
        this.members = members;
        this.closeCurlyBraceToken = closeCurlyBraceToken;
    }

    @Override
    @Nullable
    public SyntaxToken modifierToken() {
        return this.modifierToken;
    }

    @Override
    public SyntaxToken classToken() {
        return this.classEntryTypeToken;
    }

    @Override
    public NameIdentifierTree name() {
        return this.name;
    }

    @Override
    @Nullable
    public SyntaxToken extendsToken() {
        return this.extendsToken;
    }

    @Override
    @Nullable
    public NamespaceNameTree superClass() {
        return this.superClass;
    }

    @Override
    @Nullable
    public SyntaxToken implementsToken() {
        return this.implementsToken;
    }

    public SeparatedListImpl<NamespaceNameTree> superInterfaces() {
        return this.superInterfaces;
    }

    @Override
    public SyntaxToken openCurlyBraceToken() {
        return this.openCurlyBraceToken;
    }

    @Override
    public List<ClassMemberTree> members() {
        return this.members;
    }

    @Override
    public SyntaxToken closeCurlyBraceToken() {
        return this.closeCurlyBraceToken;
    }

    @Override
    @Nullable
    public MethodDeclarationTree fetchConstructor() {
        MethodDeclarationTree oldStyleConstructor = null;
        MethodDeclarationTree newStyleConstructor = null;
        for (ClassMemberTree member : this.members) {
            if (!member.is(Tree.Kind.METHOD_DECLARATION)) continue;
            MethodDeclarationTree method = (MethodDeclarationTree)member;
            String methodName = method.name().text();
            if (this.name.text().equalsIgnoreCase(methodName)) {
                oldStyleConstructor = method;
                continue;
            }
            if (!"__construct".equalsIgnoreCase(methodName)) continue;
            newStyleConstructor = method;
        }
        return newStyleConstructor != null ? newStyleConstructor : oldStyleConstructor;
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat(Iterators.forArray(this.modifierToken, this.classEntryTypeToken, this.name, this.extendsToken, this.superClass, this.implementsToken), this.superInterfaces.elementsAndSeparators(), Iterators.singletonIterator(this.openCurlyBraceToken), this.members.iterator(), Iterators.singletonIterator(this.closeCurlyBraceToken));
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitClassDeclaration(this);
    }

    public static ClassDeclarationTree createInterface(InternalSyntaxToken interfaceToken, NameIdentifierTree name, @Nullable InternalSyntaxToken extendsToken, SeparatedListImpl<NamespaceNameTree> interfaceList, InternalSyntaxToken openCurlyBraceToken, List<ClassMemberTree> members, InternalSyntaxToken closeCurlyBraceToken) {
        return new ClassDeclarationTreeImpl(Tree.Kind.INTERFACE_DECLARATION, null, interfaceToken, name, extendsToken, null, null, interfaceList, openCurlyBraceToken, members, closeCurlyBraceToken);
    }

    public static ClassDeclarationTree createTrait(InternalSyntaxToken traitToken, NameIdentifierTree name, InternalSyntaxToken openCurlyBraceToken, List<ClassMemberTree> members, InternalSyntaxToken closeCurlyBraceToken) {
        return new ClassDeclarationTreeImpl(Tree.Kind.TRAIT_DECLARATION, null, traitToken, name, null, null, null, SeparatedListImpl.empty(), openCurlyBraceToken, members, closeCurlyBraceToken);
    }

    public static ClassDeclarationTree createClass(@Nullable InternalSyntaxToken modifierToken, InternalSyntaxToken classToken, NameIdentifierTree name, @Nullable InternalSyntaxToken extendsToken, @Nullable NamespaceNameTree superClass, @Nullable InternalSyntaxToken implementsToken, SeparatedListImpl<NamespaceNameTree> superInterfaces, InternalSyntaxToken openCurlyBraceToken, List<ClassMemberTree> members, InternalSyntaxToken closeCurlyBraceToken) {
        return new ClassDeclarationTreeImpl(Tree.Kind.CLASS_DECLARATION, modifierToken, classToken, name, extendsToken, superClass, implementsToken, superInterfaces, openCurlyBraceToken, members, closeCurlyBraceToken);
    }
}

