/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl;

import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;

public abstract class PHPTree
implements Tree {
    @Nullable
    private Tree parent;

    public void setParent(Tree parent) {
        this.parent = parent;
    }

    @Override
    @Nullable
    public Tree getParent() {
        return this.parent;
    }

    public int getLine() {
        return this.getFirstToken().line();
    }

    @Override
    public final boolean is(Tree.Kind ... kind) {
        if (this.getKind() != null) {
            for (Tree.Kind kindIter : kind) {
                if (this.getKind() != kindIter) continue;
                return true;
            }
        }
        return false;
    }

    public abstract Iterator<Tree> childrenIterator();

    public boolean isLeaf() {
        return false;
    }

    public SyntaxToken getLastToken() {
        SyntaxToken lastToken = null;
        Iterator<Tree> childrenIterator = this.childrenIterator();
        while (childrenIterator.hasNext()) {
            SyntaxToken childLastToken;
            PHPTree child = (PHPTree)childrenIterator.next();
            if (child == null || (childLastToken = child.getLastToken()) == null) continue;
            lastToken = childLastToken;
        }
        return lastToken;
    }

    public SyntaxToken getFirstToken() {
        Tree child;
        Iterator<Tree> childrenIterator = this.childrenIterator();
        do {
            if (!childrenIterator.hasNext()) {
                throw new IllegalStateException("Tree has no non-null children " + this.getKind());
            }
            child = childrenIterator.next();
        } while (child == null);
        return ((PHPTree)child).getFirstToken();
    }

    public String toString() {
        if (this.is(Tree.Kind.TOKEN, Tree.Kind.INLINE_HTML_TOKEN)) {
            return ((SyntaxToken)((Object)this)).text();
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Tree> treeIterator = this.childrenIterator();
        SyntaxToken prevToken = null;
        while (treeIterator.hasNext()) {
            Tree child = treeIterator.next();
            if (child == null) continue;
            PHPTree.appendChild(sb, prevToken, child);
            prevToken = ((PHPTree)child).getLastToken();
        }
        return sb.toString();
    }

    private static void appendChild(StringBuilder sb, @Nullable SyntaxToken prevToken, Tree child) {
        SyntaxToken firstToken;
        if (prevToken != null && PHPTree.isSpaceRequired(prevToken, firstToken = ((PHPTree)child).getFirstToken())) {
            sb.append(" ");
        }
        sb.append(child.toString());
    }

    private static boolean isSpaceRequired(SyntaxToken prevToken, SyntaxToken token) {
        return token.line() > prevToken.line() || prevToken.column() + prevToken.text().length() < token.column();
    }
}

