/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.php.metrics.CognitiveComplexityVisitor;
import org.sonar.php.metrics.CommentLineVisitor;
import org.sonar.php.metrics.ComplexityVisitor;
import org.sonar.php.metrics.CounterVisitor;
import org.sonar.php.metrics.ExecutableLineVisitor;
import org.sonar.php.metrics.FileMeasures;
import org.sonar.php.metrics.LineVisitor;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;
import org.sonar.plugins.php.api.visitors.PhpFile;

public class MetricsVisitor
extends PHPSubscriptionCheck {
    private static final Number[] LIMITS_COMPLEXITY_FUNCTIONS = new Number[]{1, 2, 4, 6, 8, 10, 12};
    private static final Number[] FILES_DISTRIBUTION_BOTTOM_LIMITS = new Number[]{0, 5, 10, 20, 30, 60, 90};
    private static final Tree.Kind[] FUNCTION_NODES = new Tree.Kind[]{Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.METHOD_DECLARATION};
    private static final Tree.Kind[] CLASS_NODES = new Tree.Kind[]{Tree.Kind.CLASS_DECLARATION, Tree.Kind.INTERFACE_DECLARATION, Tree.Kind.TRAIT_DECLARATION};
    private FileMeasures fileMeasures;
    private FileLinesContext fileLinesContext;

    public static Tree.Kind[] getClassNodes() {
        return CLASS_NODES;
    }

    public static Tree.Kind[] getFunctionNodes() {
        return FUNCTION_NODES;
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        ArrayList<Tree.Kind> result = new ArrayList<Tree.Kind>(Arrays.asList(FUNCTION_NODES));
        result.addAll(Arrays.asList(CLASS_NODES));
        result.add(Tree.Kind.COMPILATION_UNIT);
        return result;
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.COMPILATION_UNIT)) {
            this.fileMeasures.setFileComplexity(ComplexityVisitor.complexity(tree));
            this.fileMeasures.setFileCognitiveComplexity(CognitiveComplexityVisitor.complexity((CompilationUnitTree)tree));
        } else if (tree.is(CLASS_NODES)) {
            this.fileMeasures.addClassComplexity(ComplexityVisitor.complexity(tree));
        } else if (tree.is(FUNCTION_NODES)) {
            this.fileMeasures.addFunctionComplexity(ComplexityVisitor.complexity(tree));
        }
    }

    public FileMeasures getFileMeasures(PhpFile file, CompilationUnitTree tree, FileLinesContext fileLinesContext) {
        this.fileMeasures = new FileMeasures(LIMITS_COMPLEXITY_FUNCTIONS, FILES_DISTRIBUTION_BOTTOM_LIMITS);
        this.fileLinesContext = fileLinesContext;
        super.analyze(file, tree);
        this.setCounterMeasures();
        this.setLineAndCommentMeasures();
        return this.fileMeasures;
    }

    private void setCounterMeasures() {
        CounterVisitor counter = new CounterVisitor(this.context().tree());
        this.fileMeasures.setClassNumber(counter.getClassNumber());
        this.fileMeasures.setFunctionNumber(counter.getFunctionNumber());
        this.fileMeasures.setStatementNumber(counter.getStatementNumber());
    }

    private void setLineAndCommentMeasures() {
        LineVisitor lineVisitor = new LineVisitor(this.context().tree());
        ExecutableLineVisitor executableLineVisitor = new ExecutableLineVisitor(this.context().tree());
        CommentLineVisitor commentVisitor = new CommentLineVisitor(this.context().tree());
        this.fileMeasures.setLinesOfCodeNumber(lineVisitor.getLinesOfCodeNumber());
        this.fileMeasures.setCommentLinesNumber(commentVisitor.commentLineNumber());
        Set<Integer> linesOfCode = lineVisitor.getLinesOfCode();
        Set<Integer> commentLines = commentVisitor.commentLines();
        linesOfCode.forEach(lineOfCode -> this.fileLinesContext.setIntValue("ncloc_data", lineOfCode.intValue(), 1));
        commentLines.forEach(commentLine -> this.fileLinesContext.setIntValue("comment_lines_data", commentLine.intValue(), 1));
        executableLineVisitor.getExecutableLines().forEach(line -> this.fileLinesContext.setIntValue("executable_lines_data", line.intValue(), 1));
        this.fileLinesContext.save();
    }
}

