/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.metrics;

import java.util.ArrayList;
import java.util.List;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpandableStringCharactersTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.InlineHTMLTree;
import org.sonar.plugins.php.api.tree.statement.UseStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;
import org.sonar.plugins.php.api.visitors.PhpFile;

public class CpdVisitor
extends PHPVisitorCheck {
    private List<CpdToken> cpdTokens = new ArrayList<CpdToken>();
    private static final String NORMALIZED_NUMERIC_LITERAL = "$NUMBER";
    private static final String NORMALIZED_CHARACTER_LITERAL = "$CHARS";

    @Override
    public void visitScript(ScriptTree tree) {
        this.scan(tree.statements());
    }

    @Override
    public void visitInlineHTML(InlineHTMLTree tree) {
    }

    @Override
    public void visitLiteral(LiteralTree tree) {
        if (tree.is(Tree.Kind.NUMERIC_LITERAL)) {
            this.addToken(tree.token(), NORMALIZED_NUMERIC_LITERAL);
        } else if (tree.is(Tree.Kind.REGULAR_STRING_LITERAL, Tree.Kind.NOWDOC_LITERAL)) {
            this.addToken(tree.token(), NORMALIZED_CHARACTER_LITERAL);
        } else {
            super.visitLiteral(tree);
        }
    }

    @Override
    public void visitExpandableStringCharacters(ExpandableStringCharactersTree tree) {
        this.addToken(tree.token(), NORMALIZED_CHARACTER_LITERAL);
    }

    @Override
    public void visitToken(SyntaxToken token) {
        if (((InternalSyntaxToken)token).isEOF()) {
            return;
        }
        this.addToken(token, token.text());
    }

    private void addToken(SyntaxToken token, String text) {
        this.cpdTokens.add(new CpdToken(token, text));
    }

    @Override
    public void visitUseStatement(UseStatementTree tree) {
    }

    public List<CpdToken> getCpdTokens(PhpFile file, CompilationUnitTree tree) {
        super.analyze(file, tree);
        return this.cpdTokens;
    }

    public static class CpdToken {
        private SyntaxToken syntaxToken;
        private String image;

        public CpdToken(SyntaxToken syntaxToken, String image) {
            this.syntaxToken = syntaxToken;
            this.image = image;
        }

        public SyntaxToken syntaxToken() {
            return this.syntaxToken;
        }

        public String image() {
            return this.image;
        }
    }
}

