/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.metrics;

import java.util.ArrayList;
import java.util.List;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ConditionalExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.statement.CaseClauseTree;
import org.sonar.plugins.php.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.php.api.tree.statement.ForEachStatementTree;
import org.sonar.plugins.php.api.tree.statement.ForStatementTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

public class ComplexityVisitor
extends PHPVisitorCheck {
    private List<Tree> complexityTrees = new ArrayList<Tree>();

    @Override
    public void visitCaseClause(CaseClauseTree tree) {
        this.incrementComplexity(tree.caseToken());
        super.visitCaseClause(tree);
    }

    @Override
    public void visitWhileStatement(WhileStatementTree tree) {
        this.incrementComplexity(tree.whileToken());
        super.visitWhileStatement(tree);
    }

    @Override
    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.incrementComplexity(tree.doToken());
        super.visitDoWhileStatement(tree);
    }

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        this.incrementComplexity(tree.ifToken());
        super.visitIfStatement(tree);
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        this.incrementComplexity(tree.forToken());
        super.visitForStatement(tree);
    }

    @Override
    public void visitForEachStatement(ForEachStatementTree tree) {
        this.incrementComplexity(tree.foreachToken());
        super.visitForEachStatement(tree);
    }

    @Override
    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        this.incrementComplexity(tree.queryToken());
        super.visitConditionalExpression(tree);
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (tree.is(Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR, Tree.Kind.ALTERNATIVE_CONDITIONAL_AND, Tree.Kind.ALTERNATIVE_CONDITIONAL_OR)) {
            this.incrementComplexity(tree.operator());
        }
        super.visitBinaryExpression(tree);
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.incrementComplexity(tree.functionToken());
        super.visitMethodDeclaration(tree);
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.incrementComplexity(tree.functionToken());
        super.visitFunctionDeclaration(tree);
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.incrementComplexity(tree.functionToken());
        super.visitFunctionExpression(tree);
    }

    private void incrementComplexity(Tree tree) {
        this.complexityTrees.add(tree);
    }

    public static int complexity(Tree tree) {
        return ComplexityVisitor.complexityTrees(tree).size();
    }

    public static List<Tree> complexityTrees(Tree tree) {
        ComplexityVisitor visitor = new ComplexityVisitor();
        tree.accept(visitor);
        return visitor.complexityTrees;
    }

    public static List<Tree> complexityNodesWithoutNestedFunctions(Tree tree) {
        ShallowComplexityVisitor visitor = new ShallowComplexityVisitor(tree);
        tree.accept(visitor);
        return visitor.complexityTrees;
    }

    public static class ShallowComplexityVisitor
    extends ComplexityVisitor {
        private Tree root;

        public ShallowComplexityVisitor(Tree root) {
            this.root = root;
        }

        @Override
        public void visitMethodDeclaration(MethodDeclarationTree tree) {
            if (tree.equals(this.root)) {
                super.visitMethodDeclaration(tree);
            }
        }

        @Override
        public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
            if (tree.equals(this.root)) {
                super.visitFunctionDeclaration(tree);
            }
        }

        @Override
        public void visitFunctionExpression(FunctionExpressionTree tree) {
            if (tree.equals(this.root)) {
                super.visitFunctionExpression(tree);
            }
        }
    }
}

