/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.metrics;

import com.google.common.collect.Sets;
import java.util.Set;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

public class CommentLineVisitor
extends PHPVisitorCheck {
    private Set<Integer> comments = Sets.newHashSet();
    private Set<Integer> noSonarLines = Sets.newHashSet();

    public CommentLineVisitor(CompilationUnitTree tree) {
        super.visitCompilationUnit(tree);
    }

    @Override
    public void visitToken(SyntaxToken token) {
        for (SyntaxTrivia trivia : token.trivias()) {
            String[] commentLines = CommentLineVisitor.getContents(trivia.text()).split("(\r)?\n|\r", -1);
            int line = trivia.line();
            for (String commentLine : commentLines) {
                if (commentLine.contains("NOSONAR")) {
                    this.noSonarLines.add(line);
                } else if (!CommentLineVisitor.isBlank(commentLine)) {
                    this.comments.add(line);
                }
                ++line;
            }
        }
        super.visitToken(token);
    }

    private static boolean isBlank(CharSequence line) {
        for (int i = 0; i < line.length(); ++i) {
            if (!Character.isLetterOrDigit(line.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static String getContents(String comment) {
        if (comment.startsWith("//")) {
            return comment.substring(2);
        }
        if (comment.startsWith("#")) {
            return comment.substring(1);
        }
        return comment.substring(2, comment.length() - 2);
    }

    public Set<Integer> noSonarLines() {
        return this.noSonarLines;
    }

    public Set<Integer> commentLines() {
        return this.comments;
    }

    public int commentLineNumber() {
        return this.comments.size();
    }
}

