/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.ini;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.sonar.sslr.api.RecognitionException;
import java.util.ArrayList;
import java.util.List;
import org.sonar.php.ini.tree.Directive;
import org.sonar.php.ini.tree.PhpIniFile;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PhpFile;

public class PhpIniParser {
    public PhpIniFile parse(PhpFile file) {
        return this.parse(file.contents());
    }

    public PhpIniFile parse(String content) {
        ArrayList<Directive> directives = new ArrayList<Directive>();
        String[] lines = content.split("\\r?\\n");
        int lineNumber = 1;
        for (String line : lines) {
            Directive directive = PhpIniParser.parseLine(line, lineNumber);
            if (directive != null) {
                directives.add(directive);
            }
            ++lineNumber;
        }
        return new PhpIniFileImpl(directives);
    }

    private static Directive parseLine(String line, int lineNumber) {
        int currentCharIndex;
        int equalSignIndex = -1;
        boolean insideString = false;
        boolean afterBackSlash = false;
        for (currentCharIndex = 0; currentCharIndex < line.length(); ++currentCharIndex) {
            char currentChar = line.charAt(currentCharIndex);
            if (!insideString) {
                if (currentChar == '=') {
                    PhpIniParser.checkState(equalSignIndex < 0, lineNumber, line);
                    equalSignIndex = currentCharIndex;
                }
                if (currentChar == ';') break;
            }
            if (currentChar == '\"' && !afterBackSlash) {
                insideString = !insideString;
            }
            afterBackSlash = currentChar == '\\';
        }
        return PhpIniParser.createDirective(line, lineNumber, equalSignIndex, currentCharIndex);
    }

    private static void checkState(boolean condition, int lineNumber, String line) {
        if (!condition) {
            throw new RecognitionException(lineNumber, "Cannot parse directive at line " + lineNumber + ":\n" + line);
        }
    }

    private static Directive createDirective(String line, int lineNumber, int equalSignIndex, int endIndex) {
        if (equalSignIndex < 0) {
            return null;
        }
        String name = line.substring(0, equalSignIndex);
        String value = line.substring(equalSignIndex + 1, endIndex);
        PhpIniParser.checkState(!name.trim().isEmpty(), lineNumber, line);
        return new DirectiveImpl(lineNumber, name, value);
    }

    private static class DirectiveImpl
    implements Directive {
        private final SyntaxToken name;
        private final SyntaxToken equalSign;
        private final SyntaxToken value;

        public DirectiveImpl(int lineNumber, String name, String value) {
            this.name = DirectiveImpl.createToken(lineNumber, name, 0);
            this.equalSign = DirectiveImpl.createToken(lineNumber, "=", name.length());
            this.value = DirectiveImpl.createToken(lineNumber, value, name.length() + 1);
        }

        private static InternalSyntaxToken createToken(int lineNumber, String untrimmed, int offsetInLine) {
            int column = DirectiveImpl.numberOfLeadingWhiteSpaces(untrimmed) + offsetInLine + 1;
            return new InternalSyntaxToken(lineNumber, column, untrimmed.trim(), ImmutableList.of(), 0, false);
        }

        private static int numberOfLeadingWhiteSpaces(String string) {
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isSpaceChar(string.charAt(i))) continue;
                return i;
            }
            return string.length();
        }

        @Override
        public SyntaxToken name() {
            return this.name;
        }

        @Override
        public SyntaxToken equalSign() {
            return this.equalSign;
        }

        @Override
        public SyntaxToken value() {
            return this.value;
        }
    }

    private static class PhpIniFileImpl
    implements PhpIniFile {
        private final List<Directive> directives;
        private final ListMultimap<String, Directive> directivesByName = ArrayListMultimap.create();

        public PhpIniFileImpl(List<Directive> directives) {
            this.directives = ImmutableList.copyOf(directives);
            for (Directive directive : directives) {
                this.directivesByName.put(directive.name().text(), directive);
            }
        }

        @Override
        public List<Directive> directives() {
            return this.directives;
        }

        @Override
        public List<Directive> directivesForName(String directiveName) {
            return this.directivesByName.get(directiveName);
        }
    }
}

