/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.highlighter;

import com.google.common.collect.ImmutableList;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.php.api.PHPKeyword;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpandableStringCharactersTree;
import org.sonar.plugins.php.api.tree.expression.ExpandableStringLiteralTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

public class SyntaxHighlighterVisitor
extends PHPVisitorCheck {
    private static final ImmutableList<String> PHP_RESERVED_VARIABLES = ImmutableList.of("__FUNCTION__", "__CLASS__", "__METHOD__", "__NAMESPACE__", "__DIR__", "__FILE__", "__LINE__", "$this");
    private static final ImmutableList<String> WORDS_TO_HIGHLIGHT = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(PHPKeyword.getKeywordValues())).addAll(PHP_RESERVED_VARIABLES)).build();
    private NewHighlighting highlighting;

    private SyntaxHighlighterVisitor(NewHighlighting highlighting) {
        this.highlighting = highlighting;
    }

    public static void highlight(Tree tree, NewHighlighting highlighting) {
        SyntaxHighlighterVisitor visitor = new SyntaxHighlighterVisitor(highlighting);
        visitor.scan(tree);
    }

    @Override
    public void visitToken(SyntaxToken token) {
        if (token.is(Tree.Kind.TOKEN) && WORDS_TO_HIGHLIGHT.contains(token.text())) {
            this.highlight(token, TypeOfText.KEYWORD);
        }
        super.visitToken(token);
    }

    @Override
    public void visitTrivia(SyntaxTrivia trivia) {
        if (trivia.text().startsWith("/**")) {
            this.highlight(trivia, TypeOfText.STRUCTURED_COMMENT);
        } else {
            this.highlight(trivia, TypeOfText.COMMENT);
        }
    }

    @Override
    public void visitExpandableStringLiteral(ExpandableStringLiteralTree tree) {
        this.highlight(tree.openDoubleQuoteToken(), TypeOfText.STRING);
        this.highlight(tree.closeDoubleQuoteToken(), TypeOfText.STRING);
        super.visitExpandableStringLiteral(tree);
    }

    @Override
    public void visitLiteral(LiteralTree tree) {
        if (tree.is(Tree.Kind.REGULAR_STRING_LITERAL)) {
            this.highlight(tree.token(), TypeOfText.STRING);
        } else if (tree.is(Tree.Kind.NUMERIC_LITERAL)) {
            this.highlight(tree.token(), TypeOfText.CONSTANT);
        }
        super.visitLiteral(tree);
    }

    @Override
    public void visitExpandableStringCharacters(ExpandableStringCharactersTree tree) {
        this.highlight(tree.token(), TypeOfText.STRING);
        super.visitExpandableStringCharacters(tree);
    }

    private void highlight(SyntaxToken token, TypeOfText typeOfText) {
        this.highlighting.highlight(token.line(), token.column(), token.endLine(), token.endColumn(), typeOfText);
    }
}

