/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.compat;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.plugins.php.api.visitors.PhpFile;

public class CompatibleInputFile
implements PhpFile {
    private final InputFile wrapped;

    public CompatibleInputFile(InputFile wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public Path relativePath() {
        return Paths.get(this.wrapped.relativePath(), new String[0]);
    }

    @Override
    public File file() {
        return this.wrapped.file();
    }

    Path path() {
        return this.wrapped.path();
    }

    @Override
    public String contents() {
        try {
            return this.wrapped.contents();
        }
        catch (IOException e) {
            throw new InputFileIOException(e);
        }
    }

    Charset charset() {
        return this.wrapped.charset();
    }

    static class InputFileIOException
    extends RuntimeException {
        InputFileIOException(Throwable cause) {
            super(cause);
        }
    }
}

