/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.utils;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sonar.php.tree.symbols.Scope;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.symbols.SymbolTable;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.VariableDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.ArrayAssignmentPatternElementTree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.expression.LexicalVariablesTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.tree.expression.VariableTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.ForEachStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

public class ReadWriteUsages {
    private final SymbolTable symbolTable;
    private final Set<SyntaxToken> writes = new HashSet<SyntaxToken>();
    private final Set<SyntaxToken> declarations = new HashSet<SyntaxToken>();
    private final ListMultimap<Symbol, Symbol> inheritedVariablesByParent = ArrayListMultimap.create();
    private final Map<Symbol, Symbol> parentSymbolByInheritedReference = new HashMap<Symbol, Symbol>();

    public ReadWriteUsages(Tree tree, SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
        tree.accept(new UsageVisitor());
    }

    public boolean isRead(Symbol symbol) {
        return this.hasReadUsage(symbol) || this.inheritedVariablesByParent.get(symbol).stream().anyMatch(this::isRead) || this.hasParentWhichIsRead(symbol);
    }

    private boolean hasReadUsage(Symbol symbol) {
        ArrayList<SyntaxToken> allReferences = new ArrayList<SyntaxToken>();
        allReferences.add(symbol.declaration().token());
        allReferences.addAll(symbol.usages());
        return allReferences.stream().anyMatch(t -> !this.writes.contains(t) && !this.declarations.contains(t));
    }

    private boolean hasParentWhichIsRead(Symbol symbol) {
        Symbol parent = this.parentSymbolByInheritedReference.get(symbol);
        return parent != null && this.hasReadUsage(parent);
    }

    private class UsageVisitor
    extends PHPVisitorCheck {
        private UsageVisitor() {
        }

        @Override
        public void visitVariableDeclaration(VariableDeclarationTree tree) {
            this.visitAssignedVariable(tree.identifier());
            super.visitVariableDeclaration(tree);
        }

        @Override
        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            this.visitAssignedVariable(tree.variable());
            super.visitAssignmentExpression(tree);
        }

        @Override
        public void visitArrayAssignmentPatternElement(ArrayAssignmentPatternElementTree tree) {
            this.visitAssignedVariable(tree.variable());
            super.visitArrayAssignmentPatternElement(tree);
        }

        @Override
        public void visitForEachStatement(ForEachStatementTree tree) {
            ExpressionTree key = tree.key();
            if (key != null) {
                this.visitAssignedVariable(key);
            }
            this.visitAssignedVariable(tree.value());
            super.visitForEachStatement(tree);
        }

        private void visitAssignedVariable(Tree tree) {
            if (!tree.is(Tree.Kind.VARIABLE_IDENTIFIER)) {
                return;
            }
            ReadWriteUsages.this.writes.add(((VariableIdentifierTree)tree).token());
        }

        @Override
        public void visitFunctionExpression(FunctionExpressionTree tree) {
            LexicalVariablesTree lexicalVars = tree.lexicalVars();
            if (lexicalVars != null) {
                Scope scope = ReadWriteUsages.this.symbolTable.getScopeFor(tree);
                for (VariableTree variableTree : lexicalVars.variables()) {
                    this.visitLexicalVar(scope, variableTree);
                }
            }
            super.visitFunctionExpression(tree);
        }

        private void visitLexicalVar(Scope scope, VariableTree variableTree) {
            Scope parentScope = scope.outer();
            VariableIdentifierTree variableIdentifier = null;
            if (variableTree.is(Tree.Kind.VARIABLE_IDENTIFIER)) {
                variableIdentifier = (VariableIdentifierTree)variableTree;
                Symbol parentScopeSymbol = parentScope.getSymbol(variableIdentifier.text(), new Symbol.Kind[0]);
                Symbol symbol = scope.getSymbol(variableIdentifier.text(), new Symbol.Kind[0]);
                if (parentScopeSymbol != null && symbol != null) {
                    ReadWriteUsages.this.inheritedVariablesByParent.put(parentScopeSymbol, symbol);
                }
            } else if (variableTree.is(Tree.Kind.REFERENCE_VARIABLE) && variableTree.variableExpression().is(Tree.Kind.VARIABLE_IDENTIFIER)) {
                variableIdentifier = (VariableIdentifierTree)variableTree.variableExpression();
                Symbol parentScopeSymbol = parentScope.getSymbol(variableIdentifier.text(), new Symbol.Kind[0]);
                Symbol symbol = scope.getSymbol(variableIdentifier.text(), new Symbol.Kind[0]);
                if (parentScopeSymbol != null && symbol != null) {
                    ReadWriteUsages.this.inheritedVariablesByParent.put(parentScopeSymbol, symbol);
                    ReadWriteUsages.this.parentSymbolByInheritedReference.put(symbol, parentScopeSymbol);
                }
            }
            if (variableIdentifier != null) {
                ReadWriteUsages.this.declarations.add(variableIdentifier.token());
            }
        }
    }
}

