/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;
import org.sonar.plugins.php.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.php.api.tree.statement.ForStatementTree;
import org.sonar.plugins.php.api.visitors.PhpFile;

public final class CheckUtils {
    private static final Tree.Kind[] FUNCTION_KINDS_ARRAY = new Tree.Kind[]{Tree.Kind.METHOD_DECLARATION, Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.FUNCTION_EXPRESSION};
    public static final ImmutableList<Tree.Kind> FUNCTION_KINDS = ImmutableList.copyOf(FUNCTION_KINDS_ARRAY);
    public static final ImmutableMap<String, String> SUPERGLOBALS_BY_OLD_NAME = ImmutableMap.builder().put("$HTTP_SERVER_VARS", "$_SERVER").put("$HTTP_GET_VARS", "$_GET").put("$HTTP_POST_VARS", "$_POST").put("$HTTP_POST_FILES", "$_FILES").put("$HTTP_SESSION_VARS", "$_SESSION").put("$HTTP_ENV_VARS", "$_ENV").put("$HTTP_COOKIE_VARS", "$_COOKIE").build();

    private CheckUtils() {
    }

    public static boolean isFunction(Tree tree) {
        return tree.is(FUNCTION_KINDS_ARRAY);
    }

    public static String getFunctionName(FunctionTree functionDec) {
        if (functionDec.is(Tree.Kind.FUNCTION_DECLARATION)) {
            return "\"" + ((FunctionDeclarationTree)functionDec).name().text() + "\"";
        }
        if (functionDec.is(Tree.Kind.METHOD_DECLARATION)) {
            return "\"" + ((MethodDeclarationTree)functionDec).name().text() + "\"";
        }
        return "expression";
    }

    @Nullable
    public static String getFunctionName(FunctionCallTree functionCall) {
        return CheckUtils.nameOf(functionCall.callee());
    }

    @Nullable
    private static String nameOf(Tree tree) {
        if (tree.is(Tree.Kind.NAMESPACE_NAME)) {
            return ((NamespaceNameTree)tree).qualifiedName();
        }
        if (tree.is(Tree.Kind.NAME_IDENTIFIER)) {
            return ((NameIdentifierTree)tree).text();
        }
        if (tree.is(Tree.Kind.CLASS_MEMBER_ACCESS)) {
            MemberAccessTree memberAccess = (MemberAccessTree)tree;
            String className = CheckUtils.nameOf(memberAccess.object());
            String memberName = CheckUtils.nameOf(memberAccess.member());
            if (className != null && memberName != null) {
                return className + "::" + memberName;
            }
        }
        return null;
    }

    public static boolean isOverriding(MethodDeclarationTree declaration) {
        for (SyntaxTrivia comment : ((PHPTree)((Object)declaration)).getFirstToken().trivias()) {
            if (!StringUtils.containsIgnoreCase(comment.text(), "@inheritdoc")) continue;
            return true;
        }
        return false;
    }

    public static boolean isExitExpression(FunctionCallTree functionCallTree) {
        String callee = functionCallTree.callee().toString();
        return "die".equalsIgnoreCase(callee) || "exit".equalsIgnoreCase(callee);
    }

    public static boolean hasModifier(List<SyntaxToken> modifiers, String toFind) {
        for (SyntaxToken modifier : modifiers) {
            if (!modifier.text().equalsIgnoreCase(toFind)) continue;
            return true;
        }
        return false;
    }

    public static boolean isClosingTag(SyntaxToken token) {
        if (token.is(Tree.Kind.INLINE_HTML_TOKEN)) {
            String text = token.text().trim();
            return "?>".equals(text) || "%>".equals(text);
        }
        return false;
    }

    public static Stream<String> lines(PhpFile file) {
        return new BufferedReader(new StringReader(file.contents())).lines();
    }

    public static ExpressionTree skipParenthesis(ExpressionTree expr) {
        if (expr.is(Tree.Kind.PARENTHESISED_EXPRESSION)) {
            return CheckUtils.skipParenthesis(((ParenthesisedExpressionTree)expr).expression());
        }
        return expr;
    }

    @Nullable
    public static Tree findPreviousSibling(Tree tree) {
        Tree child;
        Tree parent = tree.getParent();
        if (parent == null) {
            return null;
        }
        Tree previousSibling = null;
        Iterator<Tree> childrenIterator = ((PHPTree)parent).childrenIterator();
        while (childrenIterator.hasNext() && (child = childrenIterator.next()) != tree) {
            previousSibling = child;
        }
        return previousSibling;
    }

    @Nullable
    public static SyntaxToken findPreviousToken(Tree tree) {
        Tree previousSibling = CheckUtils.findPreviousSibling(tree);
        if (previousSibling != null) {
            return ((PHPTree)previousSibling).getLastToken();
        }
        return null;
    }

    public static boolean isDisguisedShortEchoStatement(Tree tree) {
        if (!tree.is(Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.EXPRESSION_LIST_STATEMENT)) {
            return false;
        }
        SyntaxToken previousToken = CheckUtils.findPreviousToken(tree);
        if (previousToken == null) {
            return false;
        }
        boolean isFileOpeningTagToken = previousToken.line() == 1 && previousToken.column() == 0;
        return (isFileOpeningTagToken || previousToken.is(Tree.Kind.INLINE_HTML_TOKEN)) && previousToken.text().endsWith("<?=");
    }

    @Nullable
    public static ExpressionTree getForCondition(ForStatementTree tree) {
        if (tree.condition().isEmpty()) {
            return null;
        }
        return (ExpressionTree)tree.condition().get(tree.condition().size() - 1);
    }
}

