/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.utils;

import java.util.ArrayList;
import java.util.List;
import org.sonar.php.checks.utils.AbstractDuplicateBranchCheck;
import org.sonar.php.checks.utils.SyntacticEquivalence;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.php.api.tree.statement.ElseifClauseTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.tree.statement.SwitchCaseClauseTree;
import org.sonar.plugins.php.api.tree.statement.SwitchStatementTree;

public abstract class AbstractDuplicateBranchImplementationCheck
extends AbstractDuplicateBranchCheck {
    @Override
    public void visitIfStatement(IfStatementTree tree) {
        if (!tree.is(Tree.Kind.IF_STATEMENT) || this.checkedIfStatements.contains(tree)) {
            super.visitIfStatement(tree);
            return;
        }
        boolean hasElse = false;
        ArrayList<List<StatementTree>> branches = new ArrayList<List<StatementTree>>();
        for (Tree clause : this.getClauses(tree)) {
            ElseClauseTree elseClause;
            if (clause.is(Tree.Kind.IF_STATEMENT)) {
                IfStatementTree ifStatementTree = (IfStatementTree)clause;
                branches.add(ifStatementTree.statements());
                continue;
            }
            if (clause.is(Tree.Kind.ELSEIF_CLAUSE)) {
                ElseifClauseTree elseifClauseTree = (ElseifClauseTree)clause;
                branches.add(elseifClauseTree.statements());
                continue;
            }
            if (!clause.is(Tree.Kind.ELSE_CLAUSE) || (elseClause = (ElseClauseTree)clause).statements().get(0).is(Tree.Kind.IF_STATEMENT)) continue;
            branches.add(elseClause.statements());
            hasElse = true;
        }
        if (hasElse && AbstractDuplicateBranchImplementationCheck.areAllEquivalent(branches)) {
            this.onAllEquivalentBranches(tree.ifToken());
        } else {
            this.checkForDuplication("branch", branches);
        }
        super.visitIfStatement(tree);
    }

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        boolean hasFallthrough = false;
        ArrayList<List<StatementTree>> normalizedBranches = new ArrayList<List<StatementTree>>();
        ArrayList<List<StatementTree>> caseBranches = new ArrayList<List<StatementTree>>();
        boolean hasDefault = false;
        int lastIndex = tree.cases().size() - 1;
        for (int i = 0; i < tree.cases().size(); ++i) {
            SwitchCaseClauseTree switchCaseClause = tree.cases().get(i);
            List<StatementTree> statements = switchCaseClause.statements();
            if (i != lastIndex && !AbstractDuplicateBranchImplementationCheck.endsWithBreak(statements)) {
                hasFallthrough = true;
            }
            if (switchCaseClause.is(Tree.Kind.DEFAULT_CLAUSE)) {
                hasDefault = true;
            } else {
                caseBranches.add(statements);
            }
            normalizedBranches.add(AbstractDuplicateBranchImplementationCheck.normalize(statements));
        }
        if (hasDefault && !hasFallthrough && AbstractDuplicateBranchImplementationCheck.areAllEquivalent(normalizedBranches)) {
            this.onAllEquivalentBranches(tree.switchToken());
        } else {
            this.checkForDuplication("case", caseBranches);
        }
        super.visitSwitchStatement(tree);
    }

    private static List<StatementTree> normalize(List<StatementTree> statements) {
        if (AbstractDuplicateBranchImplementationCheck.endsWithBreak(statements)) {
            return statements.subList(0, statements.size() - 1);
        }
        return statements;
    }

    private static boolean endsWithBreak(List<StatementTree> statements) {
        return !statements.isEmpty() && statements.get(statements.size() - 1).is(Tree.Kind.BREAK_STATEMENT);
    }

    private static boolean areAllEquivalent(List<List<StatementTree>> branches) {
        List<StatementTree> firstBranch = branches.get(0);
        return branches.stream().allMatch(branch -> SyntacticEquivalence.areSyntacticallyEquivalent(firstBranch, branch));
    }

    protected abstract void onAllEquivalentBranches(SyntaxToken var1);

    protected abstract void checkForDuplication(String var1, List<List<StatementTree>> var2);
}

