/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.formatting;

import java.util.ArrayDeque;
import java.util.Deque;
import org.sonar.php.api.PHPPunctuator;
import org.sonar.php.checks.FormattingStandardCheck;
import org.sonar.php.checks.formatting.FormattingCheck;
import org.sonar.php.checks.formatting.TokenUtils;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.expression.ExpandableStringCharactersTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

public class PunctuatorSpacingCheck
extends PHPVisitorCheck
implements FormattingCheck {
    private static final String CLOSE_PARENTHESIS_OPEN_CURLY_MESSAGE = "between the closing parenthesis and the opening curly brace.";
    private static final String OPEN_PARENTHESIS_SPACES_MESSAGE = "Remove all space after the opening parenthesis.";
    private static final String CLOSE_PARENTHESIS_SPACES_MESSAGE = "Remove all space before the closing parenthesis.";
    private static final String BOTH_PARENTHESIS_SPACES_MESSAGE = "Remove all space after the opening parenthesis and before the closing parenthesis.";
    private FormattingStandardCheck check;
    private SyntaxToken previousToken = null;
    private Deque<OpenParenthesisContext> openParenthesisLevel = new ArrayDeque<OpenParenthesisContext>();

    @Override
    public void checkFormat(FormattingStandardCheck formattingCheck, ScriptTree scriptTree) {
        this.check = formattingCheck;
        this.previousToken = null;
        this.openParenthesisLevel.clear();
        super.visitScript(scriptTree);
    }

    @Override
    public void visitExpandableStringCharacters(ExpandableStringCharactersTree tree) {
    }

    @Override
    public void visitToken(SyntaxToken token) {
        super.visitToken(token);
        if (this.previousToken != null) {
            if (PunctuatorSpacingCheck.isCloseParenthesis(this.previousToken) && PunctuatorSpacingCheck.isOpenCurly(token)) {
                this.checkSpaceBetweenCloseParenAndOpenCurly(this.previousToken, token);
            }
            if (PunctuatorSpacingCheck.isOpenParenthesis(this.previousToken)) {
                this.openParenthesisLevel.push(new OpenParenthesisContext(this.previousToken, token));
            }
            if (PunctuatorSpacingCheck.isCloseParenthesis(token)) {
                this.checkSpaceInsideParenthesis(this.openParenthesisLevel.pop(), token, this.previousToken);
            }
        }
        this.previousToken = token;
    }

    private void checkSpaceBetweenCloseParenAndOpenCurly(SyntaxToken closeParenthesis, SyntaxToken openCurly) {
        if (this.check.isOneSpaceBetweenRParentAndLCurly) {
            int nbSpace = TokenUtils.getNbSpaceBetween(closeParenthesis, openCurly);
            if (TokenUtils.isOnSameLine(closeParenthesis, openCurly) && nbSpace != 1) {
                this.check.reportIssue(TokenUtils.buildIssueMsg(nbSpace, CLOSE_PARENTHESIS_OPEN_CURLY_MESSAGE), closeParenthesis);
            }
        }
    }

    private void checkSpaceInsideParenthesis(OpenParenthesisContext openParenthesisContext, SyntaxToken closeParen, SyntaxToken closeParenPreviousToken) {
        if (this.check.isNoSpaceParenthesis) {
            boolean isRCurlyOK;
            SyntaxToken openParen = openParenthesisContext.openParenthesis;
            SyntaxToken openParenNextToken = openParenthesisContext.nextToken;
            boolean isLCurlyOK = !TokenUtils.isOnSameLine(openParenNextToken, openParen) || TokenUtils.getNbSpaceBetween(openParen, openParenNextToken) == 0;
            boolean bl = isRCurlyOK = !TokenUtils.isOnSameLine(closeParenPreviousToken, closeParen) || TokenUtils.getNbSpaceBetween(closeParenPreviousToken, closeParen) == 0;
            if (!isLCurlyOK && isRCurlyOK) {
                this.check.reportIssue(OPEN_PARENTHESIS_SPACES_MESSAGE, openParen);
            } else if (isLCurlyOK && !isRCurlyOK) {
                this.check.reportIssue(CLOSE_PARENTHESIS_SPACES_MESSAGE, closeParen);
            } else if (!isLCurlyOK) {
                this.check.reportIssue(BOTH_PARENTHESIS_SPACES_MESSAGE, openParen, closeParen);
            }
        }
    }

    private static boolean isOpenParenthesis(SyntaxToken token) {
        return TokenUtils.isType(token, PHPPunctuator.LPARENTHESIS);
    }

    private static boolean isOpenCurly(SyntaxToken token) {
        return TokenUtils.isType(token, PHPPunctuator.LCURLYBRACE);
    }

    private static boolean isCloseParenthesis(SyntaxToken token) {
        return TokenUtils.isType(token, PHPPunctuator.RPARENTHESIS);
    }

    private static class OpenParenthesisContext {
        final SyntaxToken openParenthesis;
        final SyntaxToken nextToken;

        public OpenParenthesisContext(SyntaxToken openParenthesis, SyntaxToken nextToken) {
            this.openParenthesis = openParenthesis;
            this.nextToken = nextToken;
        }
    }
}

