/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.formatting;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.php.checks.FormattingStandardCheck;
import org.sonar.php.checks.formatting.FormattingCheck;
import org.sonar.php.checks.formatting.TokenUtils;
import org.sonar.php.checks.utils.TokenVisitor;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.expression.LexicalVariablesTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

public class FunctionSpacingCheck
extends PHPVisitorCheck
implements FormattingCheck {
    private static final String METHOD_NAME_SPACES_MESSAGE = "Remove all space between the method name \"%s\" and the opening parenthesis.";
    private static final String CLOSURE_SPACES_MESSAGE = "Put exactly one space between the \"function\" keyword and the opening parenthesis.";
    private static final String CLOSURE_LEXICAL_VARS_SPACES_MESSAGE = "Put exactly one space before and after the \"use\" keyword.";
    private static final String[] COMMA_SPACES_MESSAGE = new String[]{"Remove any space before comma separated arguments.", "Put exactly one space after comma separated arguments.", "Remove any space before comma separated arguments and put exactly one space after comma separated arguments."};
    private FormattingStandardCheck check;

    @Override
    public void checkFormat(FormattingStandardCheck formattingCheck, ScriptTree scriptTree) {
        this.check = formattingCheck;
        super.visitScript(scriptTree);
    }

    @Override
    public void visitParameterList(ParameterListTree tree) {
        this.checkSpaceForComma(new TokenVisitor(tree), tree.parameters().getSeparators());
        super.visitParameterList(tree);
    }

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        if (!this.check.isInternalFunction(tree.callee())) {
            this.checkSpaceForComma(new TokenVisitor(tree), tree.arguments().getSeparators());
            this.checkSpaceAfterFunctionName(((PHPTree)((Object)tree.callee())).getLastToken(), tree.openParenthesisToken());
        }
        super.visitFunctionCall(tree);
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.checkSpaceAfterFunctionName(tree.name().token(), tree.parameters().openParenthesisToken());
        super.visitMethodDeclaration(tree);
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.checkSpaceAfterFunctionName(tree.name().token(), tree.parameters().openParenthesisToken());
        super.visitFunctionDeclaration(tree);
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.checkClosureSpacing(tree.functionToken(), tree.parameters(), tree.lexicalVars());
        super.visitFunctionExpression(tree);
    }

    private void checkClosureSpacing(SyntaxToken functionKeyword, ParameterListTree parameters, @Nullable LexicalVariablesTree lexicalVars) {
        if (this.check.isClosureSpacing) {
            if (TokenUtils.getNbSpaceBetween(functionKeyword, parameters.openParenthesisToken()) != 1) {
                this.check.reportIssue(CLOSURE_SPACES_MESSAGE, functionKeyword);
            }
            if (lexicalVars != null) {
                int spaceBeforeUse = TokenUtils.getNbSpaceBetween(parameters.closeParenthesisToken(), lexicalVars.useToken());
                int spaceAfterUse = TokenUtils.getNbSpaceBetween(lexicalVars.useToken(), lexicalVars.openParenthesisToken());
                if (spaceBeforeUse != 1 || spaceAfterUse != 1) {
                    this.check.reportIssue(CLOSURE_LEXICAL_VARS_SPACES_MESSAGE, lexicalVars.useToken());
                }
            }
        }
    }

    private void checkSpaceAfterFunctionName(SyntaxToken functionName, SyntaxToken openParenthesis) {
        if (this.check.isNoSpaceAfterMethodName && TokenUtils.getNbSpaceBetween(functionName, openParenthesis) != 0) {
            this.check.reportIssue(String.format(METHOD_NAME_SPACES_MESSAGE, functionName.text()), functionName);
        }
    }

    private void checkSpaceForComma(TokenVisitor tokenVisitor, List<SyntaxToken> commas) {
        block1: {
            if (!this.check.isOneSpaceAfterComma) break block1;
            for (SyntaxToken commaToken : commas) {
                if (this.checkComma(commaToken, tokenVisitor)) break;
            }
        }
    }

    private boolean checkComma(SyntaxToken commaToken, TokenVisitor tokenVisitor) {
        SyntaxToken nextToken = tokenVisitor.nextToken(commaToken);
        SyntaxToken previousToken = tokenVisitor.prevToken(commaToken);
        if (TokenUtils.isOnSameLine(previousToken, commaToken, nextToken)) {
            boolean isSpaceAfterOK;
            boolean isSpaceBeforeOK = TokenUtils.getNbSpaceBetween(previousToken, commaToken) == 0;
            boolean bl = isSpaceAfterOK = TokenUtils.getNbSpaceBetween(commaToken, nextToken) == 1;
            if (!isSpaceBeforeOK && isSpaceAfterOK) {
                this.check.reportIssue(COMMA_SPACES_MESSAGE[0], commaToken);
                return true;
            }
            if (isSpaceBeforeOK && !isSpaceAfterOK) {
                this.check.reportIssue(COMMA_SPACES_MESSAGE[1], commaToken);
                return true;
            }
            if (!isSpaceBeforeOK) {
                this.check.reportIssue(COMMA_SPACES_MESSAGE[2], commaToken);
                return true;
            }
        }
        return false;
    }
}

