/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.formatting;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.php.api.PHPPunctuator;
import org.sonar.php.checks.FormattingStandardCheck;
import org.sonar.php.checks.formatting.FormattingCheck;
import org.sonar.php.checks.formatting.TokenUtils;
import org.sonar.php.checks.utils.TokenVisitor;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.ForEachStatementTree;
import org.sonar.plugins.php.api.tree.statement.TryStatementTree;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;

public class ControlStructureSpacingCheck
extends PHPSubscriptionCheck
implements FormattingCheck {
    private static final String CONTROL_STRUCTURES_KEYWORD_MESSAGE = "between this \"%s\" keyword and the opening %s";
    private static final String FOR_SEMICOLON_MESSAGE = "Put exactly one space after each \";\" character in the \"for\" statement.";
    private static final String FOREACH_MESSAGE = "Put exactly one space after and before %s in \"foreach\" statement.";
    private static final Tree.Kind[] CONTROL_STRUCTURES = new Tree.Kind[]{Tree.Kind.IF_STATEMENT, Tree.Kind.ELSEIF_CLAUSE, Tree.Kind.ELSE_CLAUSE, Tree.Kind.DO_WHILE_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.FOREACH_STATEMENT, Tree.Kind.SWITCH_STATEMENT, Tree.Kind.TRY_STATEMENT, Tree.Kind.CATCH_BLOCK};
    private FormattingStandardCheck check;

    @Override
    public void checkFormat(FormattingStandardCheck formattingCheck, ScriptTree scriptTree) {
        this.check = formattingCheck;
        this.scanTree(scriptTree);
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.copyOf(CONTROL_STRUCTURES);
    }

    @Override
    public void visitNode(Tree tree) {
        if (this.check.isOneSpaceBetweenKeywordAndNextToken) {
            this.checkSpaceBetweenKeywordAndNextNode(new TokenVisitor(tree), tree);
        }
        if (this.check.isOneSpaceAfterForLoopSemicolon && tree.is(Tree.Kind.FOR_STATEMENT)) {
            this.checkSpaceForStatement(tree);
        }
        if (this.check.isSpaceForeachStatement && tree.is(Tree.Kind.FOREACH_STATEMENT)) {
            ForEachStatementTree foreachLoop = (ForEachStatementTree)tree;
            this.checkForeachStatement(new TokenVisitor(tree), foreachLoop, foreachLoop.asToken(), foreachLoop.doubleArrowToken());
        }
    }

    private void checkForeachStatement(TokenVisitor tokenVisitor, ForEachStatementTree foreachLoop, SyntaxToken asKeyword, @Nullable SyntaxToken doubleArrow) {
        boolean isSpaceCorrectAs = ControlStructureSpacingCheck.isExactlyOneSpaceAround(tokenVisitor, asKeyword);
        boolean isSpaceCorrectDoubleArrow = doubleArrow == null || ControlStructureSpacingCheck.isExactlyOneSpaceAround(tokenVisitor, doubleArrow);
        String messageDetail = null;
        ArrayList<SyntaxToken> issueLocations = new ArrayList<SyntaxToken>();
        if (!isSpaceCorrectAs && isSpaceCorrectDoubleArrow) {
            messageDetail = "\"as\"";
            issueLocations.add(foreachLoop.asToken());
        } else if (isSpaceCorrectAs && !isSpaceCorrectDoubleArrow) {
            messageDetail = "\"=>\"";
            issueLocations.add(foreachLoop.doubleArrowToken());
        } else if (!isSpaceCorrectAs && !isSpaceCorrectDoubleArrow) {
            messageDetail = "\"as\" and \"=>\"";
            issueLocations.add(foreachLoop.asToken());
            issueLocations.add(foreachLoop.doubleArrowToken());
        }
        if (messageDetail != null) {
            this.check.reportIssue(String.format(FOREACH_MESSAGE, messageDetail), issueLocations.toArray(new Tree[issueLocations.size()]));
        }
    }

    private static boolean isExactlyOneSpaceAround(TokenVisitor tokenVisitor, SyntaxToken token) {
        return TokenUtils.getNbSpaceBetween(tokenVisitor.prevToken(token), token) == 1 && TokenUtils.getNbSpaceBetween(token, tokenVisitor.nextToken(token)) == 1;
    }

    private void checkSpaceForStatement(Tree tree) {
        Iterator<Tree> iterator = ((PHPTree)tree).childrenIterator();
        Tree previous = null;
        while (iterator.hasNext()) {
            SyntaxToken nextToken;
            SyntaxToken semicolonToken;
            int nbSpace;
            Tree next = iterator.next();
            if (ControlStructureSpacingCheck.isSemicolon(previous) && (nbSpace = TokenUtils.getNbSpaceBetween(semicolonToken = (SyntaxToken)previous, nextToken = ((PHPTree)next).getFirstToken())) != 1 && TokenUtils.isOnSameLine(semicolonToken, nextToken)) {
                this.check.reportIssue(FOR_SEMICOLON_MESSAGE, semicolonToken);
                break;
            }
            previous = next;
        }
    }

    private static boolean isSemicolon(@Nullable Tree tree) {
        return tree != null && tree.is(Tree.Kind.TOKEN) && TokenUtils.isType((SyntaxToken)tree, PHPPunctuator.SEMICOLON);
    }

    private void checkSpaceBetweenKeywordAndNextNode(TokenVisitor tokenVisitor, Tree tree) {
        TryStatementTree tryStatement;
        SyntaxToken keyword = tokenVisitor.firstKeyword();
        if (tree.is(Tree.Kind.TRY_STATEMENT) && (tryStatement = (TryStatementTree)tree).finallyToken() != null) {
            SyntaxToken finallyKeyword = tryStatement.finallyToken();
            this.checkSpaceBetweenKeywordAndNextNode(finallyKeyword, tokenVisitor.nextToken(finallyKeyword));
        }
        this.checkSpaceBetweenKeywordAndNextNode(keyword, tokenVisitor.nextToken(keyword));
    }

    private void checkSpaceBetweenKeywordAndNextNode(SyntaxToken keyword, SyntaxToken nextToken) {
        int nbSpace;
        if (TokenUtils.isType(nextToken, PHPPunctuator.LCURLYBRACE, PHPPunctuator.LPARENTHESIS) && TokenUtils.isOnSameLine(keyword, nextToken) && (nbSpace = TokenUtils.getNbSpaceBetween(keyword, nextToken)) != 1) {
            String endMessage = String.format(CONTROL_STRUCTURES_KEYWORD_MESSAGE, keyword.text(), TokenUtils.isType(nextToken, PHPPunctuator.LPARENTHESIS) ? "parenthesis." : "curly brace.");
            this.check.reportIssue(TokenUtils.buildIssueMsg(nbSpace, endMessage), keyword);
        }
    }
}

