/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.expression.AssignmentExpressionTreeImpl;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;

@Rule(key="S2757")
public class WrongAssignmentOperatorCheck
extends PHPSubscriptionCheck {
    private static final Set<String> SUSPICIOUS_TOKEN_VALUES = ImmutableSet.of("!", "+", "-");

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.ASSIGNMENT);
    }

    @Override
    public void visitNode(Tree tree) {
        AssignmentExpressionTree aeTree = (AssignmentExpressionTree)tree;
        SyntaxToken expressionFirstToken = ((PHPTree)((Object)aeTree.value())).getFirstToken();
        SyntaxToken variableLastToken = ((PHPTree)((Object)aeTree.variable())).getLastToken();
        SyntaxToken operatorToken = ((AssignmentExpressionTreeImpl)aeTree).equalToken();
        if (WrongAssignmentOperatorCheck.isSuspiciousToken(expressionFirstToken) && WrongAssignmentOperatorCheck.noSpacingBetween(operatorToken, expressionFirstToken) && !WrongAssignmentOperatorCheck.noSpacingBetween(variableLastToken, operatorToken)) {
            this.context().newIssue(this, operatorToken, expressionFirstToken, "Was \"" + expressionFirstToken.text() + "=\" meant instead?");
        }
    }

    private static boolean noSpacingBetween(SyntaxToken firstToken, SyntaxToken secondToken) {
        return firstToken.column() + firstToken.text().length() == secondToken.column();
    }

    private static boolean isSuspiciousToken(SyntaxToken firstToken) {
        return SUSPICIOUS_TOKEN_VALUES.contains(firstToken.text());
    }
}

