/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Deque;
import java.util.LinkedList;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.utils.SyntacticEquivalence;
import org.sonar.php.tree.symbols.Scope;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2123")
public class UselessIncrementCheck
extends PHPVisitorCheck {
    public static final String KEY = "S2123";
    private Deque<Scope> scopes = new LinkedList<Scope>();

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
    }

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.scopes.clear();
        super.visitCompilationUnit(tree);
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.scopes.push(this.context().symbolTable().getScopeFor(tree));
        super.visitMethodDeclaration(tree);
        this.scopes.pop();
    }

    @Override
    public void visitClassDeclaration(ClassDeclarationTree tree) {
        this.scopes.push(this.context().symbolTable().getScopeFor(tree));
        super.visitClassDeclaration(tree);
        this.scopes.pop();
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.scopes.push(this.context().symbolTable().getScopeFor(tree));
        super.visitFunctionDeclaration(tree);
        this.scopes.pop();
    }

    @Override
    public void visitReturnStatement(ReturnStatementTree tree) {
        ExpressionTree postfixedExpression;
        ExpressionTree returnedExpression = tree.expression();
        if (returnedExpression != null && (returnedExpression = CheckUtils.skipParenthesis(returnedExpression)).is(Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT) && (postfixedExpression = CheckUtils.skipParenthesis(((UnaryExpressionTree)returnedExpression).expression())).is(Tree.Kind.VARIABLE_IDENTIFIER) && this.isFromCurrentScope((VariableIdentifierTree)postfixedExpression)) {
            this.reportIssue(returnedExpression);
        }
        super.visitReturnStatement(tree);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isFromCurrentScope(VariableIdentifierTree variableIdentifierTree) {
        SyntaxToken variableToken = variableIdentifierTree.token();
        Scope currentScope = this.scopes.peek();
        if (currentScope == null) return false;
        if (!currentScope.getSymbols(Symbol.Kind.VARIABLE).stream().filter(symbol -> !symbol.hasModifier("static") && !symbol.hasModifier("global")).filter(symbol -> currentScope.equals(symbol.scope())).flatMap(symbol -> symbol.usages().stream()).anyMatch(variableToken::equals)) return false;
        return true;
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        ExpressionTree expression;
        if (tree.is(Tree.Kind.ASSIGNMENT) && (expression = CheckUtils.skipParenthesis(tree.value())).is(Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT) && SyntacticEquivalence.areSyntacticallyEquivalent(tree.variable(), ((UnaryExpressionTree)expression).expression())) {
            this.reportIssue(expression);
        }
        super.visitAssignmentExpression(tree);
    }

    private void reportIssue(ExpressionTree expression) {
        String message = String.format("Remove this %s or correct the code not to waste it.", expression.is(Tree.Kind.POSTFIX_INCREMENT) ? "increment" : "decrement");
        this.context().newIssue(this, expression, message);
    }
}

