/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S905")
public class UselessExpressionStatementCheck
extends PHPVisitorCheck {
    public static final String KEY = "S905";
    private static final String MESSAGE = "Remove or refactor this statement.";
    private static final Tree.Kind[] USELESS_KINDS = new Tree.Kind[]{Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.EQUAL_TO, Tree.Kind.STRICT_EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.STRICT_NOT_EQUAL_TO, Tree.Kind.LESS_THAN, Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO, Tree.Kind.GREATER_THAN_OR_EQUAL_TO, Tree.Kind.PLUS, Tree.Kind.MINUS, Tree.Kind.REMAINDER, Tree.Kind.MULTIPLY, Tree.Kind.DIVIDE, Tree.Kind.LEFT_SHIFT, Tree.Kind.RIGHT_SHIFT, Tree.Kind.INSTANCE_OF, Tree.Kind.ALTERNATIVE_NOT_EQUAL_TO, Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS, Tree.Kind.LOGICAL_COMPLEMENT, Tree.Kind.REGULAR_STRING_LITERAL, Tree.Kind.EXPANDABLE_STRING_LITERAL, Tree.Kind.CONCATENATION, Tree.Kind.NAME_IDENTIFIER, Tree.Kind.NUMERIC_LITERAL, Tree.Kind.NULL_LITERAL, Tree.Kind.BOOLEAN_LITERAL};
    private boolean fileContainsHTML;
    private List<Tree> uselessNodes;

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.fileContainsHTML = false;
        this.uselessNodes = new ArrayList<Tree>();
        super.visitCompilationUnit(tree);
        if (!this.fileContainsHTML) {
            for (Tree uselessNode : this.uselessNodes) {
                this.context().newIssue(this, uselessNode, MESSAGE);
            }
        }
    }

    @Override
    public void visitExpressionStatement(ExpressionStatementTree tree) {
        ExpressionTree expression = tree.expression();
        if (expression.is(USELESS_KINDS)) {
            this.uselessNodes.add(tree);
        }
        super.visitExpressionStatement(tree);
    }

    @Override
    public void visitToken(SyntaxToken token) {
        if (token.is(Tree.Kind.INLINE_HTML_TOKEN) && !CheckUtils.isClosingTag(token)) {
            this.fileContainsHTML = true;
        }
    }
}

