/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.php.checks.IgnoredReturnValueCheck;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.VariableDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.expression.ArrayAccessTree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.expression.LexicalVariablesTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.tree.expression.VariableTree;
import org.sonar.plugins.php.api.tree.statement.ForEachStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S836")
public class UseOfUninitializedVariableCheck
extends PHPVisitorCheck {
    private static final Set<Tree.Kind> PARENT_INITIALIZATION_KIND = EnumSet.of(Tree.Kind.PARAMETER, new Tree.Kind[]{Tree.Kind.GLOBAL_STATEMENT, Tree.Kind.VARIABLE_DECLARATION, Tree.Kind.REFERENCE_VARIABLE, Tree.Kind.ARRAY_ASSIGNMENT_PATTERN_ELEMENT, Tree.Kind.UNSET_VARIABLE_STATEMENT, Tree.Kind.CATCH_BLOCK, Tree.Kind.ASSIGNMENT_BY_REFERENCE});
    private static final Set<String> FUNCTION_CHANGING_CURRENT_SCOPE = new HashSet<String>(Arrays.asList("eval", "extract", "parse_str", "preg_replace", "include", "include_once", "require", "require_once"));
    private static final Set<String> PREDEFINED_VARIABLES = new HashSet<String>(Arrays.asList("$_COOKIE", "$_ENV", "$_FILES", "$_GET", "$_POST", "$_REQUEST", "$_SERVER", "$_SESSION", "$GLOBALS", "$HTTP_RAW_POST_DATA", "$http_response_header", "$php_errormsg", "$this"));
    private static final Set<String> FUNCTION_ALLOWING_ARGUMENT_CHECK = new HashSet<String>(IgnoredReturnValueCheck.PURE_FUNCTIONS);
    private static final Map<Tree.Kind, Predicate<Tree>> IS_READ_ACCESS_BY_PARENT_KIND;

    private static Map<Tree.Kind, Predicate<Tree>> initializeReadPredicate() {
        EnumMap<Tree.Kind, Predicate<Tree>> map = new EnumMap<Tree.Kind, Predicate<Tree>>(Tree.Kind.class);
        PARENT_INITIALIZATION_KIND.forEach(kind -> map.put((Tree.Kind)kind, tree -> false));
        map.put(Tree.Kind.ASSIGNMENT, tree -> tree == ((AssignmentExpressionTree)tree.getParent()).value());
        map.put(Tree.Kind.FUNCTION_CALL, tree -> {
            FunctionCallTree functionCall = (FunctionCallTree)tree.getParent();
            return tree == functionCall.callee() || FUNCTION_ALLOWING_ARGUMENT_CHECK.contains(UseOfUninitializedVariableCheck.lowerCaseFunctionName(functionCall));
        });
        map.put(Tree.Kind.FOREACH_STATEMENT, tree -> tree == ((ForEachStatementTree)tree.getParent()).expression());
        map.put(Tree.Kind.ARRAY_ACCESS, tree -> !UseOfUninitializedVariableCheck.isArrayAssignment(tree));
        map.put(Tree.Kind.PARENTHESISED_EXPRESSION, tree -> UseOfUninitializedVariableCheck.isReadAccess(tree.getParent()));
        return map;
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.checkFunction(tree);
        super.visitFunctionDeclaration(tree);
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.checkFunction(tree);
        super.visitFunctionExpression(tree);
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.checkFunction(tree);
        super.visitMethodDeclaration(tree);
    }

    private void checkFunction(FunctionTree function) {
        VariableVisitor visitor = new VariableVisitor(function);
        function.accept(visitor);
        visitor.uninitializedStream().forEach(variable -> this.context().newIssue(this, (Tree)variable, "Review the data-flow - use of uninitialized value."));
    }

    private static boolean isReadAccess(Tree tree) {
        Predicate<Tree> predicate = IS_READ_ACCESS_BY_PARENT_KIND.get(tree.getParent().getKind());
        return predicate == null || predicate.test(tree);
    }

    @Nullable
    private static String lowerCaseFunctionName(FunctionCallTree functionCall) {
        String name = CheckUtils.getFunctionName(functionCall);
        return name != null ? name.toLowerCase(Locale.ROOT) : null;
    }

    private static boolean isArrayAssignment(Tree tree) {
        Tree child = UseOfUninitializedVariableCheck.skipParentArrayAccess(tree);
        return child.getParent().is(Tree.Kind.ASSIGNMENT) && ((AssignmentExpressionTree)child.getParent()).variable() == child;
    }

    private static Tree skipParentArrayAccess(Tree tree) {
        Tree child;
        for (child = tree; child.getParent().is(Tree.Kind.ARRAY_ACCESS) && ((ArrayAccessTree)child.getParent()).object() == child; child = child.getParent()) {
        }
        return child;
    }

    static {
        FUNCTION_ALLOWING_ARGUMENT_CHECK.remove("isset");
        IS_READ_ACCESS_BY_PARENT_KIND = UseOfUninitializedVariableCheck.initializeReadPredicate();
    }

    private static class VariableVisitor
    extends PHPVisitorCheck {
        final FunctionTree currentFunction;
        boolean trustVariables = true;
        Map<String, VariableIdentifierTree> firstVariableReadAccess = new HashMap<String, VariableIdentifierTree>();
        Set<String> initializedVariables = new HashSet<String>();

        VariableVisitor(FunctionTree currentFunction) {
            this.currentFunction = currentFunction;
        }

        Stream<VariableIdentifierTree> uninitializedStream() {
            if (!this.trustVariables) {
                return Stream.empty();
            }
            return this.firstVariableReadAccess.entrySet().stream().filter(entry -> !this.initializedVariables.contains(entry.getKey())).map(Map.Entry::getValue);
        }

        @Override
        public void visitVariableIdentifier(VariableIdentifierTree tree) {
            if (VariableVisitor.isClassMemberAccess(tree) || VariableVisitor.uninitializedVariableDeclaration(tree)) {
                return;
            }
            String name = tree.text();
            if (!PREDEFINED_VARIABLES.contains(name)) {
                if (UseOfUninitializedVariableCheck.isReadAccess(tree)) {
                    if (!this.firstVariableReadAccess.containsKey(name)) {
                        this.firstVariableReadAccess.put(name, tree);
                    }
                } else {
                    this.initializedVariables.add(name);
                }
            }
        }

        @Override
        public void visitFunctionCall(FunctionCallTree functionCall) {
            if (FUNCTION_CHANGING_CURRENT_SCOPE.contains(UseOfUninitializedVariableCheck.lowerCaseFunctionName(functionCall))) {
                this.trustVariables = false;
            }
            super.visitFunctionCall(functionCall);
        }

        @Override
        public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
            if (tree == this.currentFunction) {
                super.visitFunctionDeclaration(tree);
            }
        }

        @Override
        public void visitFunctionExpression(FunctionExpressionTree tree) {
            LexicalVariablesTree lexicalVars = tree.lexicalVars();
            if (tree == this.currentFunction) {
                if (lexicalVars != null) {
                    lexicalVars.variables().stream().map(VariableTree::variableExpression).filter(variable -> variable.is(Tree.Kind.VARIABLE_IDENTIFIER)).map(variable -> ((VariableIdentifierTree)variable).text()).forEach(this.initializedVariables::add);
                }
                super.visitFunctionExpression(tree);
            } else if (lexicalVars != null) {
                this.scan(lexicalVars.variables());
            }
        }

        @Override
        public void visitClassDeclaration(ClassDeclarationTree tree) {
        }

        @Override
        public void visitAnonymousClass(AnonymousClassTree tree) {
        }

        private static boolean isClassMemberAccess(Tree tree) {
            Tree child = UseOfUninitializedVariableCheck.skipParentArrayAccess(tree);
            return child.getParent().is(Tree.Kind.CLASS_MEMBER_ACCESS) && ((MemberAccessTree)child.getParent()).member() == child;
        }

        private static boolean uninitializedVariableDeclaration(Tree tree) {
            return tree.getParent().is(Tree.Kind.VARIABLE_DECLARATION) && ((VariableDeclarationTree)tree.getParent()).equalToken() == null;
        }
    }
}

