/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.utils.ReadWriteUsages;
import org.sonar.php.tree.symbols.Scope;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.expression.IdentifierTree;
import org.sonar.plugins.php.api.tree.expression.ReferenceVariableTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.tree.expression.VariableTree;
import org.sonar.plugins.php.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.php.api.tree.statement.ForEachStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1481")
public class UnusedLocalVariableCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1481";
    private static final String MESSAGE = "Remove this unused \"%s\" local variable.";
    private List<IdentifierTree> exclusions = new ArrayList<IdentifierTree>();
    private Set<Tree> raisedIssueLocations = new HashSet<Tree>();
    private ReadWriteUsages usages;

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        if (tree.lexicalVars() != null) {
            Scope parentScope = this.context().symbolTable().getScopeFor(tree).outer();
            for (VariableTree variableTree : tree.lexicalVars().variables()) {
                VariableIdentifierTree variableIdentifier;
                Symbol parentScopeSymbol;
                if (!variableTree.is(Tree.Kind.VARIABLE_IDENTIFIER) || (parentScopeSymbol = parentScope.getSymbol((variableIdentifier = (VariableIdentifierTree)variableTree).text(), new Symbol.Kind[0])) != null) continue;
                this.exclusions.add(variableIdentifier);
            }
        }
        super.visitFunctionExpression(tree);
    }

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        for (ExpressionTree argument : tree.arguments()) {
            if (!argument.is(Tree.Kind.VARIABLE_IDENTIFIER)) continue;
            this.exclusions.add((IdentifierTree)argument);
        }
        super.visitFunctionCall(tree);
    }

    @Override
    public void visitCatchBlock(CatchBlockTree tree) {
        this.exclusions.add(tree.variable());
        super.visitCatchBlock(tree);
    }

    @Override
    public void visitForEachStatement(ForEachStatementTree tree) {
        if (tree.key() != null) {
            if (tree.value().is(Tree.Kind.VARIABLE_IDENTIFIER)) {
                this.exclusions.add((IdentifierTree)tree.value());
            } else if (tree.value().is(Tree.Kind.REFERENCE_VARIABLE) && ((ReferenceVariableTree)tree.value()).variableExpression().is(Tree.Kind.VARIABLE_IDENTIFIER)) {
                this.exclusions.add((IdentifierTree)((ReferenceVariableTree)tree.value()).variableExpression());
            }
        }
        super.visitForEachStatement(tree);
    }

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.exclusions.clear();
        this.raisedIssueLocations.clear();
        this.usages = new ReadWriteUsages(tree, this.context().symbolTable());
        super.visitCompilationUnit(tree);
        for (Scope scope : this.context().symbolTable().getScopes()) {
            if (!CheckUtils.isFunction(scope.tree())) continue;
            this.checkScope(scope);
        }
    }

    private void checkScope(Scope scope) {
        for (Symbol symbol : scope.getSymbols(Symbol.Kind.VARIABLE)) {
            if (!symbol.scope().equals(scope) || this.usages.isRead(symbol) || this.exclusions.contains(symbol.declaration()) || this.raisedIssueLocations.contains(symbol.declaration())) continue;
            this.context().newIssue(this, symbol.declaration(), String.format(MESSAGE, symbol.name()));
            this.raisedIssueLocations.add(symbol.declaration());
        }
    }
}

