/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1131")
public class TrailingWhitespaceCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1131";
    private static final String MESSAGE = "Remove the useless trailing whitespaces at the end of this line.";
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("[^\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]+[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]+$");

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        Stream<String> lines = CheckUtils.lines(this.context().getPhpFile());
        Iterator it = lines.iterator();
        int i = 0;
        while (it.hasNext()) {
            if (TrailingWhitespaceCheck.test((String)it.next())) {
                this.context().newLineIssue(this, i + 1, MESSAGE);
            }
            ++i;
        }
    }

    private static boolean test(String line) {
        return line.length() > 0 && WHITESPACE_PATTERN.matcher(line).find();
    }
}

