/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.metrics.LineVisitor;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.FunctionTree;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;

@Rule(key="S138")
public class TooManyLinesInFunctionCheck
extends PHPSubscriptionCheck {
    public static final String KEY = "S138";
    private static final String MESSAGE = "This function %s has %s lines, which is greater than the %s lines authorized. Split it into smaller functions.";
    private static final int DEFAULT = 150;
    @RuleProperty(key="max", description="Maximum authorized lines of code in a function", defaultValue="150")
    public int max = 150;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return CheckUtils.FUNCTION_KINDS;
    }

    @Override
    public void visitNode(Tree tree) {
        FunctionTree declaration = (FunctionTree)tree;
        int nbLines = TooManyLinesInFunctionCheck.getNumberOfLines(declaration);
        if (nbLines > this.max) {
            this.context().newIssue(this, declaration.functionToken(), declaration.parameters(), String.format(MESSAGE, CheckUtils.getFunctionName(declaration), nbLines, this.max));
        }
    }

    public static int getNumberOfLines(FunctionTree declaration) {
        if (!declaration.body().is(Tree.Kind.BLOCK)) {
            return 0;
        }
        return LineVisitor.linesOfCode(declaration);
    }
}

