/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.statement.SwitchCaseClauseTree;
import org.sonar.plugins.php.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S131")
public class SwitchWithoutDefaultCheck
extends PHPVisitorCheck {
    public static final String KEY = "S131";

    @Override
    public void visitSwitchStatement(SwitchStatementTree switchTree) {
        SwitchCaseClauseTree defaultClause = null;
        int defaultClauseIndex = 0;
        for (SwitchCaseClauseTree clause : switchTree.cases()) {
            if (clause.is(Tree.Kind.DEFAULT_CLAUSE)) {
                defaultClause = clause;
                break;
            }
            ++defaultClauseIndex;
        }
        if (defaultClause == null) {
            this.context().newIssue(this, switchTree.switchToken(), "Add a \"case default\" clause to this \"switch\" statement.");
        } else if (defaultClauseIndex < switchTree.cases().size() - 1) {
            this.context().newIssue(this, defaultClause.caseToken(), "Move this \"case default\" clause to the end of this \"switch\" statement.");
        }
        super.visitSwitchStatement(switchTree);
    }
}

