/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;
import org.sonar.plugins.php.api.visitors.PreciseIssue;

@Rule(key="S1192")
public class StringLiteralDuplicatedCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1192";
    private static final String MESSAGE = "Define a constant instead of duplicating this literal \"%s\" %s times.";
    private static final Integer MINIMAL_LITERAL_LENGTH = 5;
    private final Map<String, LiteralTree> firstOccurrenceTrees = Maps.newHashMap();
    private final Map<String, List<LiteralTree>> sameLiteralOccurrences = Maps.newHashMap();
    public static final int DEFAULT = 3;
    @RuleProperty(key="threshold", defaultValue="3")
    int threshold = 3;

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.firstOccurrenceTrees.clear();
        this.sameLiteralOccurrences.clear();
        super.visitCompilationUnit(tree);
        this.finish();
    }

    private void finish() {
        for (Map.Entry<String, List<LiteralTree>> literalOccurrences : this.sameLiteralOccurrences.entrySet()) {
            List<LiteralTree> occurrences = literalOccurrences.getValue();
            if (occurrences.size() < this.threshold) continue;
            String literal = literalOccurrences.getKey();
            String message = String.format(MESSAGE, literal, occurrences.size());
            PreciseIssue issue = this.context().newIssue(this, this.firstOccurrenceTrees.get(literal), message).cost(occurrences.size());
            occurrences.forEach(occurrence -> issue.secondary((Tree)occurrence, null));
        }
    }

    @Override
    public void visitLiteral(LiteralTree tree) {
        String literal;
        String value;
        if (tree.is(Tree.Kind.REGULAR_STRING_LITERAL) && (value = StringUtils.substring(literal = tree.value(), 1, literal.length() - 1)).length() >= MINIMAL_LITERAL_LENGTH) {
            if (!this.sameLiteralOccurrences.containsKey(value)) {
                ArrayList<LiteralTree> occurrences = new ArrayList<LiteralTree>();
                occurrences.add(tree);
                this.sameLiteralOccurrences.put(value, occurrences);
                this.firstOccurrenceTrees.put(value, tree);
            } else {
                this.sameLiteralOccurrences.get(value).add(tree);
            }
        }
    }
}

