/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.ReferenceVariableTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1998")
public class ReferenceInFunctionCallCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1998";
    private static final String MESSAGE = "Remove the '&' to pass \"%s\" by value.";

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        super.visitFunctionCall(tree);
        for (ExpressionTree argument : tree.arguments()) {
            if (!argument.is(Tree.Kind.REFERENCE_VARIABLE)) continue;
            String message = String.format(MESSAGE, ((ReferenceVariableTree)argument).variableExpression().toString());
            this.context().newIssue(this, argument, message);
        }
    }
}

