/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1779")
public class NonLFCharAsEOLCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1779";
    private static final String MESSAGE = "Replace all non line feed end of line characters in this file \"%s\" by LF.";

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        String contents = this.context().getPhpFile().contents();
        for (int i = 0; i < contents.length(); ++i) {
            char c = contents.charAt(i);
            if (c != '\r' && c != '\u2028' && c != '\u2029') continue;
            String message = String.format(MESSAGE, this.context().getPhpFile().relativePath().getFileName());
            this.context().newFileIssue(this, message);
            break;
        }
    }
}

