/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.expression.ConditionalExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;
import org.sonar.plugins.php.api.visitors.PreciseIssue;

@Rule(key="S3358")
public class NestedTernaryOperatorsCheck
extends PHPVisitorCheck {
    @Override
    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        TernaryVisitor visitor = new TernaryVisitor();
        tree.falseExpression().accept(visitor);
        ExpressionTree trueExpression = tree.trueExpression();
        if (trueExpression != null) {
            trueExpression.accept(visitor);
        }
        tree.condition().accept(visitor);
        if (!visitor.descendantTernaries.isEmpty()) {
            ConditionalExpressionTree first = visitor.descendantTernaries.get(0);
            PreciseIssue issue = this.context().newIssue(this, first, "Extract this nested ternary operation into an independent statement.");
            visitor.descendantTernaries.stream().skip(1L).forEach(ternary -> issue.secondary((Tree)ternary, "Other nested ternary"));
            issue.secondary(tree.queryToken(), "Parent ternary operator");
        }
    }

    private static class TernaryVisitor
    extends PHPVisitorCheck {
        List<ConditionalExpressionTree> descendantTernaries = new ArrayList<ConditionalExpressionTree>();

        private TernaryVisitor() {
        }

        @Override
        public void visitConditionalExpression(ConditionalExpressionTree tree) {
            this.descendantTernaries.add(tree);
        }

        @Override
        public void visitFunctionExpression(FunctionExpressionTree tree) {
        }

        @Override
        public void visitAnonymousClass(AnonymousClassTree tree) {
        }
    }
}

