/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayDeque;
import java.util.Deque;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;
import org.sonar.plugins.php.api.visitors.PreciseIssue;

@Rule(key="S2004")
public class NestedFunctionDepthCheck
extends PHPVisitorCheck {
    public static final String KEY = "S2004";
    private static final String MESSAGE = "Refactor this code to not nest functions more than %s levels deep.";
    private Deque<SyntaxToken> nestedStack = new ArrayDeque<SyntaxToken>();
    public static final int DEFAULT = 3;
    @RuleProperty(key="max", defaultValue="3")
    int max = 3;

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.nestedStack.clear();
        super.visitCompilationUnit(tree);
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.enterFunction(tree);
        super.visitFunctionDeclaration(tree);
        this.exitFunction();
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.enterFunction(tree);
        super.visitMethodDeclaration(tree);
        this.exitFunction();
    }

    private void enterFunction(FunctionTree tree) {
        this.nestedStack.push(tree.functionToken());
        if (this.nestedStack.size() == this.max + 1) {
            PreciseIssue issue = this.context().newIssue(this, tree.functionToken(), String.format(MESSAGE, this.max));
            this.nestedStack.forEach(secondary -> issue.secondary((Tree)secondary, "Nesting +1"));
        }
    }

    private void exitFunction() {
        this.nestedStack.pop();
    }
}

