/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import org.sonar.check.Rule;
import org.sonar.php.api.PHPKeyword;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassPropertyDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;

@Rule(key="S1124")
public class ModifiersOrderCheck
extends PHPSubscriptionCheck {
    public static final String KEY = "S1124";
    private static final String MESSAGE = "Reorder the modifiers to comply with the PSR2 standard.";
    private static final String[] EXPECTED_ORDER = new String[]{PHPKeyword.FINAL.getValue(), PHPKeyword.ABSTRACT.getValue(), PHPKeyword.PUBLIC.getValue(), PHPKeyword.PROTECTED.getValue(), PHPKeyword.PRIVATE.getValue(), PHPKeyword.STATIC.getValue()};

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of(Tree.Kind.METHOD_DECLARATION, Tree.Kind.CLASS_PROPERTY_DECLARATION);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.METHOD_DECLARATION)) {
            this.checkModifiers(((MethodDeclarationTree)tree).modifiers());
        } else {
            this.checkModifiers(((ClassPropertyDeclarationTree)tree).modifierTokens());
        }
    }

    private void checkModifiers(List<SyntaxToken> modifiers) {
        if (modifiers.size() > 1) {
            int i = 0;
            for (SyntaxToken modifier : modifiers) {
                String normalizedModifier = modifier.text().toLowerCase(Locale.ENGLISH);
                while (i < EXPECTED_ORDER.length && !EXPECTED_ORDER[i].equals(normalizedModifier)) {
                    ++i;
                }
            }
            if (i == EXPECTED_ORDER.length) {
                this.context().newIssue(this, modifiers.get(0), modifiers.get(modifiers.size() - 1), MESSAGE);
            }
        }
    }
}

