/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.php.api.PHPKeyword;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassMemberTree;
import org.sonar.plugins.php.api.tree.declaration.ClassTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1784")
public class MissingMethodVisibilityCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1784";
    private static final String MESSAGE = "Explicitly mention the visibility of this %s \"%s\".";
    private static final Set<String> VISIBILITIES = ImmutableSet.of(PHPKeyword.PRIVATE.getValue(), PHPKeyword.PROTECTED.getValue(), PHPKeyword.PUBLIC.getValue());

    @Override
    public void visitClassDeclaration(ClassDeclarationTree tree) {
        super.visitClassDeclaration(tree);
        if (tree.is(Tree.Kind.CLASS_DECLARATION)) {
            this.visitClass(tree, tree.name().text());
        }
    }

    @Override
    public void visitAnonymousClass(AnonymousClassTree tree) {
        super.visitAnonymousClass(tree);
        this.visitClass(tree, null);
    }

    private void visitClass(ClassTree classTree, @Nullable String name) {
        for (ClassMemberTree member : classTree.members()) {
            if (!member.is(Tree.Kind.METHOD_DECLARATION)) continue;
            this.checkMethod((MethodDeclarationTree)member, name);
        }
    }

    private void checkMethod(MethodDeclarationTree method, @Nullable String className) {
        if (!MissingMethodVisibilityCheck.hasVisibilityModifier(method)) {
            String methodName = method.name().text();
            String message = String.format(MESSAGE, MissingMethodVisibilityCheck.getMethodKind(methodName, className), methodName);
            this.context().newIssue(this, method.name(), message);
        }
    }

    private static boolean hasVisibilityModifier(MethodDeclarationTree method) {
        for (SyntaxToken modifier : method.modifiers()) {
            if (!VISIBILITIES.contains(modifier.text().toLowerCase(Locale.ENGLISH))) continue;
            return true;
        }
        return false;
    }

    private static String getMethodKind(String methodName, @Nullable String className) {
        if ("__construct".equalsIgnoreCase(methodName) || methodName.equalsIgnoreCase(className)) {
            return "constructor";
        }
        if ("__destruct".equalsIgnoreCase(methodName)) {
            return "destructor";
        }
        return "method";
    }
}

