/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.api.PHPPunctuator;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;

@Rule(key="S2010")
public class LogicalWordOperatorUsageCheck
extends PHPSubscriptionCheck {
    public static final String KEY = "S2010";
    public static final String MESSAGE = "Replace \"%s\" with \"%s\".";

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of(Tree.Kind.ALTERNATIVE_CONDITIONAL_AND, Tree.Kind.ALTERNATIVE_CONDITIONAL_OR);
    }

    @Override
    public void visitNode(Tree tree) {
        SyntaxToken operator = ((BinaryExpressionTree)tree).operator();
        String replacement = tree.is(Tree.Kind.ALTERNATIVE_CONDITIONAL_AND) ? PHPPunctuator.ANDAND.getValue() : PHPPunctuator.OROR.getValue();
        this.context().newIssue(this, operator, String.format(MESSAGE, operator.text(), replacement));
    }
}

