/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.FunctionTree;
import org.sonar.plugins.php.api.tree.declaration.ParameterTree;
import org.sonar.plugins.php.api.tree.expression.ArrayAccessTree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;

@Rule(key="S117")
public class LocalVariableAndParameterNameCheck
extends PHPSubscriptionCheck {
    public static final String KEY = "S117";
    private static final String MESSAGE = "Rename this %s \"%s\" to match the regular expression %s.";
    private static final ImmutableSet<String> SUPERGLOBALS = ImmutableSet.of("$GLOBALS", "$_SERVER", "$_GET", "$_POST", "$_FILES", "$_COOKIE", new String[]{"$_SESSION", "$_REQUEST", "$_ENV"});
    public static final String DEFAULT = "^[a-z][a-zA-Z0-9]*$";
    private Deque<Set<String>> checkedVariables = new ArrayDeque<Set<String>>();
    private Pattern pattern = null;
    @RuleProperty(key="format", defaultValue="^[a-z][a-zA-Z0-9]*$")
    String format = "^[a-z][a-zA-Z0-9]*$";

    @Override
    public void init() {
        this.pattern = Pattern.compile(this.format);
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(CheckUtils.FUNCTION_KINDS)).add(Tree.Kind.ASSIGNMENT_BY_REFERENCE)).add(new Tree.Kind[]{Tree.Kind.ASSIGNMENT, Tree.Kind.POWER_ASSIGNMENT, Tree.Kind.MULTIPLY_ASSIGNMENT, Tree.Kind.DIVIDE_ASSIGNMENT, Tree.Kind.REMAINDER_ASSIGNMENT, Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT, Tree.Kind.LEFT_SHIFT_ASSIGNMENT, Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.AND_ASSIGNMENT, Tree.Kind.XOR_ASSIGNMENT, Tree.Kind.OR_ASSIGNMENT, Tree.Kind.CONCATENATION_ASSIGNMENT})).build();
    }

    @Override
    public void visitNode(Tree tree) {
        if (CheckUtils.isFunction(tree)) {
            this.enterScope();
            this.checkParameters((FunctionTree)tree);
        } else if (this.inScope()) {
            this.checkLocalVariable(tree);
        }
    }

    @Override
    public void leaveNode(Tree tree) {
        if (CheckUtils.isFunction(tree)) {
            this.leaveScope();
        }
    }

    private void checkLocalVariable(Tree tree) {
        VariableIdentifierTree variableIdentifier;
        String variableName;
        ExpressionTree variable = LocalVariableAndParameterNameCheck.getLeftHandExpression(tree);
        if (variable.is(Tree.Kind.VARIABLE_IDENTIFIER) && !this.isAlreadyChecked(variableName = (variableIdentifier = (VariableIdentifierTree)variable).variableExpression().text()) && !this.isCompliant(variableName)) {
            this.reportIssue("local variable", variable, variableName);
        }
    }

    private void checkParameters(FunctionTree functionDec) {
        for (ParameterTree parameter : functionDec.parameters().parameters()) {
            String paramName = parameter.variableIdentifier().variableExpression().text();
            if (this.isCompliant(paramName)) continue;
            this.reportIssue("parameter", parameter, paramName);
        }
    }

    private void reportIssue(String type, Tree tree, String varName) {
        this.context().newIssue(this, tree, String.format(MESSAGE, type, varName, this.format));
        this.setAsCheckedVariable(varName);
    }

    private static ExpressionTree getLeftHandExpression(Tree assignmentExpr) {
        ExpressionTree leftExpression = ((AssignmentExpressionTree)assignmentExpr).variable();
        while (leftExpression.is(Tree.Kind.ARRAY_ACCESS)) {
            leftExpression = ((ArrayAccessTree)leftExpression).object();
        }
        return leftExpression;
    }

    private boolean isCompliant(String varName) {
        return this.pattern.matcher(StringUtils.remove(varName, "$")).matches() || LocalVariableAndParameterNameCheck.isSuperGlobal(varName);
    }

    private static boolean isSuperGlobal(String varName) {
        return SUPERGLOBALS.contains(varName);
    }

    private void setAsCheckedVariable(String varName) {
        this.checkedVariables.peek().add(varName);
    }

    private boolean isAlreadyChecked(String varName) {
        return this.checkedVariables.peek().contains(varName);
    }

    private boolean inScope() {
        return !this.checkedVariables.isEmpty();
    }

    private void enterScope() {
        this.checkedVariables.push(new HashSet());
    }

    private void leaveScope() {
        this.checkedVariables.pop();
    }
}

