/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.php.api.PHPKeyword;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1781")
public class KeywordsAndConstantsNotLowerCaseCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1781";
    private static final String MESSAGE = "Write this \"%s\" %s in lower case.";
    private static final Pattern PATTERN = Pattern.compile("[a-z_]+");
    private static final Set<String> KEYWORDS = ImmutableSet.copyOf(PHPKeyword.getKeywordValues());

    @Override
    public void visitLiteral(LiteralTree tree) {
        super.visitLiteral(tree);
        if (tree.is(Tree.Kind.NULL_LITERAL, Tree.Kind.BOOLEAN_LITERAL)) {
            this.check(tree, tree.value(), "constant");
        }
    }

    @Override
    public void visitToken(SyntaxToken token) {
        super.visitToken(token);
        if (KEYWORDS.contains(token.text().toLowerCase(Locale.ENGLISH))) {
            this.check(token, token.text(), "keyword");
        }
    }

    private void check(Tree tree, String value, String kind) {
        if (!PATTERN.matcher(value).matches()) {
            String message = String.format(MESSAGE, value, kind);
            this.context().newIssue(this, tree, message);
        }
    }
}

