/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1997")
public class InlineHTMLInFileCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1997";
    private static final String MESSAGE = "Remove the inline HTML in this file.";
    private boolean fileHasIssue;

    @Override
    public void visitToken(SyntaxToken token) {
        if (token.is(Tree.Kind.INLINE_HTML_TOKEN) && !CheckUtils.isClosingTag(token)) {
            this.fileHasIssue = true;
        }
    }

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        if (!this.isExcludedFile()) {
            this.fileHasIssue = false;
            super.visitCompilationUnit(tree);
            if (this.fileHasIssue) {
                this.context().newFileIssue(this, MESSAGE);
            }
        }
    }

    private boolean isExcludedFile() {
        String filename = this.context().getPhpFile().relativePath().getFileName().toString();
        return filename.endsWith(".phtml");
    }
}

