/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.VariableDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.IdentifierTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1075")
public class HardCodedUriCheck
extends PHPVisitorCheck {
    private static final String SCHEME = "^(?!.*php)[a-zA-Z\\+\\.\\-]+";
    private static final String URI_REGEX = "^(?!.*php)[a-zA-Z\\+\\.\\-]+://[^\\$]+";
    private static final Pattern URI_PATTERN = Pattern.compile("^(?!.*php)[a-zA-Z\\+\\.\\-]+://[^\\$]+");
    private static final Pattern VARIABLE_NAME_PATTERN = Pattern.compile("filename|path", 2);
    private static final Set<String> WHITELIST = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("basename")).add("chgrp")).add("chmod")).add("chown")).add("clearstatcache")).add("copy")).add("delete")).add("dirname")).add("disk_\u200bfree_\u200bspace")).add("disk_\u200btotal_\u200bspace")).add("diskfreespace")).add("fclose")).add("feof")).add("fflush")).add("fgetc")).add("fgetcsv")).add("fgets")).add("fgetss")).add("file_\u200bexists")).add("file_\u200bget_\u200bcontents")).add("file_\u200bput_\u200bcontents")).add("file")).add("fileatime")).add("filectime")).add("filegroup")).add("fileinode")).add("filemtime")).add("fileowner")).add("fileperms")).add("filesize")).add("filetype")).add("flock")).add("fnmatch")).add("fopen")).add("fpassthru")).add("fputcsv")).add("fputs")).add("fread")).add("fscanf")).add("fseek")).add("fstat")).add("ftell")).add("ftruncate")).add("fwrite")).add("glob")).add("is_\u200bdir")).add("is_\u200bexecutable")).add("is_\u200bfile")).add("is_\u200blink")).add("is_\u200breadable")).add("is_\u200buploaded_\u200bfile")).add("is_\u200bwritable")).add("is_\u200bwriteable")).add("lchgrp")).add("lchown")).add("link")).add("linkinfo")).add("lstat")).add("mkdir")).add("move_\u200buploaded_\u200bfile")).add("parse_\u200bini_\u200bfile")).add("parse_\u200bini_\u200bstring")).add("pathinfo")).add("pclose")).add("popen")).add("readfile")).add("readlink")).add("realpath_\u200bcache_\u200bget")).add("realpath_\u200bcache_\u200bsize")).add("realpath")).add("rename")).add("rewind")).add("rmdir")).add("set_\u200bfile_\u200bbuffer")).add("stat")).add("symlink")).add("tempnam")).add("tmpfile")).add("touch")).add("umask")).add("unlink")).build();

    private static boolean isFileNameVariable(IdentifierTree variable) {
        return VARIABLE_NAME_PATTERN.matcher(variable.text()).find();
    }

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        String functionName = CheckUtils.getFunctionName(tree);
        if (functionName != null && (functionName.startsWith("http_") || WHITELIST.contains(functionName))) {
            tree.arguments().forEach(this::checkExpression);
        }
        super.visitFunctionCall(tree);
    }

    @Override
    public void visitVariableDeclaration(VariableDeclarationTree tree) {
        if (HardCodedUriCheck.isFileNameVariable(tree.identifier())) {
            this.checkExpression(tree.initValue());
        }
        super.visitVariableDeclaration(tree);
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (tree.variable().is(Tree.Kind.VARIABLE_IDENTIFIER) && HardCodedUriCheck.isFileNameVariable(((VariableIdentifierTree)tree.variable()).variableExpression())) {
            this.checkExpression(tree.value());
        }
        super.visitAssignmentExpression(tree);
    }

    private void checkExpression(@Nullable ExpressionTree expr) {
        if (expr != null && HardCodedUriCheck.isHardcodedURI(expr)) {
            this.reportHardcodedURI(expr);
        }
    }

    private static boolean isHardcodedURI(ExpressionTree expr) {
        ExpressionTree newExpr = CheckUtils.skipParenthesis(expr);
        if (!newExpr.is(Tree.Kind.REGULAR_STRING_LITERAL)) {
            return false;
        }
        String stringLiteral = HardCodedUriCheck.trimQuotes(((LiteralTree)newExpr).value());
        return URI_PATTERN.matcher(stringLiteral).find();
    }

    private static String trimQuotes(String value) {
        return value.substring(1, value.length());
    }

    private void reportHardcodedURI(ExpressionTree hardcodedURI) {
        this.context().newIssue(this, hardcodedURI, "Refactor your code to get this URI from a customizable parameter.");
    }
}

