/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.VariableDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2068")
public class HardCodedCredentialsCheck
extends PHPVisitorCheck {
    public static final String KEY = "S2068";
    private static final String MESSAGE = "'%s' detected in this variable name, review this potentially hardcoded credential.";
    private static final String DEFAULT_CREDENTIAL_WORDS = "password,passwd,pwd";
    @RuleProperty(key="credentialWords", description="Comma separated list of words identifying potential credentials", defaultValue="password,passwd,pwd")
    public String credentialWords = "password,passwd,pwd";
    private List<Pattern> variablePatterns = null;
    private List<Pattern> literalPatterns = null;

    private Stream<Pattern> variablePatterns() {
        if (this.variablePatterns == null) {
            this.variablePatterns = this.toPatterns("");
        }
        return this.variablePatterns.stream();
    }

    private Stream<Pattern> literalPatterns() {
        if (this.literalPatterns == null) {
            this.literalPatterns = this.toPatterns("=..");
        }
        return this.literalPatterns.stream();
    }

    private List<Pattern> toPatterns(String suffix) {
        return Stream.of(this.credentialWords.split(",")).map(String::trim).map(word -> Pattern.compile(word + suffix, 2)).collect(Collectors.toList());
    }

    @Override
    public void visitLiteral(LiteralTree literal) {
        if (literal.is(Tree.Kind.REGULAR_STRING_LITERAL)) {
            this.checkCredential(literal, literal.token().text(), this.literalPatterns());
        }
        super.visitLiteral(literal);
    }

    @Override
    public void visitVariableDeclaration(VariableDeclarationTree declaration) {
        this.checkVariable(declaration.identifier().token(), declaration.initValue());
        super.visitVariableDeclaration(declaration);
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree assignment) {
        this.checkVariable(((PHPTree)((Object)assignment.variable())).getLastToken(), assignment.value());
        super.visitAssignmentExpression(assignment);
    }

    private void checkVariable(SyntaxToken reportTree, @Nullable Tree assignedValue) {
        if (assignedValue != null && assignedValue.is(Tree.Kind.REGULAR_STRING_LITERAL)) {
            this.checkCredential(reportTree, reportTree.text(), this.variablePatterns());
        }
    }

    private void checkCredential(Tree reportTree, String target, Stream<Pattern> patterns) {
        patterns.filter(pattern -> pattern.matcher(target).find()).findAny().ifPresent(pattern -> this.addIssue((Pattern)pattern, reportTree));
    }

    private void addIssue(Pattern pattern, Tree tree) {
        this.context().newIssue(this, tree, String.format(MESSAGE, HardCodedCredentialsCheck.cleanedPattern(pattern.pattern())));
    }

    private static String cleanedPattern(String pattern) {
        if (pattern.endsWith("=..")) {
            return pattern.substring(0, pattern.length() - 3);
        }
        return pattern;
    }
}

