/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.php.api.tree.statement.NamespaceStatementTree;
import org.sonar.plugins.php.api.tree.statement.ThrowStatementTree;
import org.sonar.plugins.php.api.tree.statement.UseClauseTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S112")
public class GenericExceptionCheck
extends PHPVisitorCheck {
    public static final String KEY = "S112";
    public static final String MESSAGE = "Define and throw a dedicated exception instead of using a generic one.";
    private static final Set<String> RAW_EXCEPTIONS = ImmutableSet.of("ErrorException", "RuntimeException", "Exception");
    private Set<String> importedGenericExceptions = Sets.newHashSet();
    private boolean inGlobalNamespace = true;

    @Override
    public void visitScript(ScriptTree tree) {
        this.importedGenericExceptions.clear();
        this.inGlobalNamespace = true;
        super.visitScript(tree);
    }

    @Override
    public void visitThrowStatement(ThrowStatementTree tree) {
        NamespaceNameTree namespaceName = GenericExceptionCheck.getThrownClassName(tree);
        if (namespaceName != null && this.isGenericException(namespaceName)) {
            this.context().newIssue(this, namespaceName, MESSAGE);
        }
        super.visitThrowStatement(tree);
    }

    @Override
    public void visitUseClause(UseClauseTree tree) {
        String qualifiedName = tree.namespaceName().qualifiedName();
        if (RAW_EXCEPTIONS.contains(qualifiedName)) {
            this.importedGenericExceptions.add(tree.alias() != null ? tree.alias().text() : qualifiedName);
        }
        super.visitUseClause(tree);
    }

    @Override
    public void visitNamespaceStatement(NamespaceStatementTree tree) {
        if (tree.namespaceName() != null) {
            this.inGlobalNamespace = false;
        }
        super.visitNamespaceStatement(tree);
        if (tree.openCurlyBrace() != null) {
            this.inGlobalNamespace = true;
        }
    }

    private boolean isGenericException(NamespaceNameTree namespaceName) {
        return this.isImportedGenericException(namespaceName) || this.isGlobalNamespaceGenericException(namespaceName);
    }

    private boolean isImportedGenericException(NamespaceNameTree namespaceName) {
        return this.importedGenericExceptions.contains(namespaceName.fullName());
    }

    private boolean isGlobalNamespaceGenericException(NamespaceNameTree namespaceName) {
        return this.isFromGlobalNamespace(namespaceName) && RAW_EXCEPTIONS.contains(namespaceName.name().text());
    }

    private boolean isFromGlobalNamespace(NamespaceNameTree namespaceName) {
        return !namespaceName.hasQualifiers() && (namespaceName.isFullyQualified() || this.inGlobalNamespace);
    }

    @Nullable
    private static NamespaceNameTree getThrownClassName(ThrowStatementTree tree) {
        if (tree.expression().is(Tree.Kind.NEW_EXPRESSION)) {
            NewExpressionTree newExpression = (NewExpressionTree)tree.expression();
            if (newExpression.expression().is(Tree.Kind.FUNCTION_CALL)) {
                FunctionCallTree functionCall = (FunctionCallTree)newExpression.expression();
                if (functionCall.callee().is(Tree.Kind.NAMESPACE_NAME)) {
                    return (NamespaceNameTree)functionCall.callee();
                }
            }
        }
        return null;
    }
}

